set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8726488';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-5-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '0',
      NULL,
      NULL,
      '1021412',
      58.287560,
      2,
      0,
      0,
      '222112',
      NULL,
      ' 7-16-1978',
      30,
      NULL,
      0.968635,
      NULL,
      0.944270,
      0.265905,
      NULL,
      NULL,
      0,
      0.573061,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0.200855,
      NULL,
      0,
      NULL,
      0.167961,
      2.536519,
      0,
      0.971183,
      1,
      1,
      0.951701,
      NULL,
      0,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      1.409664,
      NULL,
      NULL,
      NULL,
      2,
      7.529045,
      3,
      0,
      0,
      2.761000,
      3,
      2.921235,
      0,
      NULL,
      0.108740,
      0,
      NULL,
      1,
      NULL,
      0.299858,
      3.438950,
      NULL,
      0,
      1,
      0.001666,
      NULL,
      0,
      1,
      0.273993,
      0.821210,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.193123,
      NULL,
      1,
      1,
      NULL,
      0,
      4,
      5,
      1,
      NULL,
      5,
      1,
      1.876592,
      1,
      1,
      0,
      NULL,
      0,
      0,
      1,
      0,
      NULL,
      1,
      3.785958,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2.510044,
      3.519563,
      NULL,
      1,
      1,
      0.611533,
      1.781543,
      2.010668,
      1.683481,
      2.033031,
      1,
      2,
      NULL,
      1,
      NULL,
      0.943856,
      0.695524,
      0.569677,
      1,
      9.164509,
      1.780154,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.333453,
      0,
      NULL,
      1,
      0.670687,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.377444,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.890846,
      NULL,
      1,
      1,
      0.341651,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0.561555,
      1.825973,
      1.580156,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.724082,
      1.581286,
      1.886080,
      NULL,
      0,
      0.738129,
      NULL,
      1,
      1,
      1.188282,
      1.280298,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0.541131,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      '30120',
      '',
      '',
      1.345129,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


