set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8726488';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-10-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '2',
      NULL,
      NULL,
      '2033331',
      24,
      6,
      0,
      0,
      '440333',
      0,
      ' 7-19-1974',
      NULL,
      NULL,
      0.656201,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.213819,
      3,
      1,
      NULL,
      0.492247,
      NULL,
      1.203057,
      0.512650,
      NULL,
      0,
      NULL,
      0,
      3.955925,
      0.231044,
      0.516700,
      1,
      1.725153,
      1.212009,
      NULL,
      1,
      0.354775,
      0,
      1.202966,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.248698,
      2.762526,
      NULL,
      1.295201,
      0,
      1.306508,
      1.590152,
      3,
      3.330936,
      NULL,
      0.152434,
      0.072043,
      NULL,
      2.854448,
      1,
      0.042027,
      1.998696,
      NULL,
      0,
      1.465068,
      NULL,
      0.012477,
      2,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.191077,
      NULL,
      NULL,
      NULL,
      5.587421,
      2.298572,
      NULL,
      5,
      0,
      5.206569,
      NULL,
      NULL,
      NULL,
      2.099373,
      0.213879,
      NULL,
      5,
      1.842002,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      2.249456,
      NULL,
      0,
      1,
      1.449754,
      4,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      2,
      0,
      NULL,
      1,
      1,
      NULL,
      3.733555,
      2,
      3.331691,
      3,
      3.137400,
      2.218615,
      NULL,
      1,
      NULL,
      0.667739,
      1.200493,
      1,
      1.461919,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.885476,
      1,
      NULL,
      0,
      1.387328,
      1,
      0.671397,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.546896,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.550537,
      0.562859,
      2.822024,
      0.929144,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.600961,
      1,
      0.832056,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.423604,
      0.174043,
      2.825340,
      NULL,
      0,
      3.888350,
      1.706587,
      2.819207,
      0.140554,
      NULL,
      0,
      1.675532,
      NULL,
      0.139184,
      1,
      0.037778,
      0,
      1,
      NULL,
      0.661554,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.124274,
      '14221',
      '',
      '',
      1,
      '',
      '',
      NULL,
      1,
      '',
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


