set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8726488';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-3-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '0',
      NULL,
      NULL,
      '2004224',
      53.181310,
      NULL,
      3.451664,
      3,
      NULL,
      2,
      ' 1- 3-1994',
      NULL,
      NULL,
      0,
      NULL,
      4,
      1.134303,
      1.673600,
      0.296426,
      1.543903,
      NULL,
      1,
      NULL,
      NULL,
      1.476427,
      2,
      0.431698,
      1,
      1.922894,
      0.213015,
      0.600295,
      3,
      0.556314,
      0.609166,
      0,
      1,
      NULL,
      7.125929,
      0,
      NULL,
      0.115083,
      1.904924,
      0,
      NULL,
      NULL,
      0.835649,
      NULL,
      NULL,
      1,
      4,
      0,
      1,
      1.870296,
      0.653031,
      0,
      2.162601,
      1.406628,
      NULL,
      1,
      1.718628,
      0,
      1.687788,
      2.944554,
      1,
      1,
      0,
      1.632947,
      1,
      0,
      1,
      5.348061,
      1,
      NULL,
      NULL,
      1.172050,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1.602345,
      3.912705,
      1,
      0.639787,
      NULL,
      NULL,
      0.480479,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      0.550490,
      0,
      1.674680,
      1.633003,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1.757698,
      NULL,
      0.635535,
      0,
      NULL,
      NULL,
      0,
      0,
      0.288188,
      2,
      1,
      NULL,
      0,
      5,
      3,
      3,
      3.119529,
      3,
      2.896129,
      6,
      0,
      0.191400,
      NULL,
      0.312203,
      1.708676,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      0.916130,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.234076,
      NULL,
      NULL,
      NULL,
      NULL,
      0.469679,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2.353798,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2.121743,
      NULL,
      0.875557,
      NULL,
      0,
      NULL,
      1,
      0,
      1,
      0.088320,
      1.175748,
      1.253857,
      0,
      0.191555,
      1.912811,
      0.683798,
      1.790965,
      0.913113,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      '42224',
      '',
      NULL,
      1,
      '',
      NULL,
      NULL,
      0.356457,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


