set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8726488';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-11-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '030',
      '02',
      2,
      4,
      '4204223',
      NULL,
      NULL,
      0.308269,
      NULL,
      '041032',
      3.905176,
      NULL,
      7,
      93,
      1.617800,
      NULL,
      1.621573,
      3,
      NULL,
      0,
      NULL,
      0,
      1.235708,
      0.918677,
      0,
      0,
      1.570149,
      0,
      1.098590,
      1,
      1,
      NULL,
      NULL,
      1,
      0.173317,
      0.322238,
      0,
      1,
      5,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.272781,
      NULL,
      NULL,
      NULL,
      1.295682,
      1,
      0.150853,
      1.527704,
      0.030368,
      2,
      3,
      0.214246,
      0,
      0.242840,
      1.787675,
      1.935729,
      2.247697,
      1.771056,
      1,
      3,
      2.179869,
      0.442359,
      NULL,
      1.676941,
      NULL,
      3.613493,
      0,
      NULL,
      1.159648,
      1.631135,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.382734,
      1.618773,
      0,
      1,
      0,
      0.851195,
      0.646785,
      1.859657,
      1.146950,
      NULL,
      NULL,
      1.884473,
      0.881564,
      1,
      1.940276,
      NULL,
      1.502224,
      0,
      1.876921,
      NULL,
      1,
      NULL,
      NULL,
      0.447334,
      0,
      0.250330,
      1,
      0,
      1.412712,
      NULL,
      0.356506,
      0.247385,
      1.649593,
      1,
      1,
      NULL,
      3.101840,
      NULL,
      3.742527,
      3,
      0,
      2,
      1,
      0.648718,
      5.932694,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.755889,
      1.212622,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.015205,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.397434,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      0.224912,
      0,
      1.290918,
      NULL,
      NULL,
      NULL,
      0.759872,
      NULL,
      0.892829,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.424592,
      NULL,
      2.743555,
      NULL,
      2,
      NULL,
      NULL,
      0.100322,
      1,
      0.501912,
      3.372184,
      1,
      1.751023,
      0.568704,
      1.265468,
      0.931481,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      '43124',
      '',
      '',
      0,
      '',
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


