set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8726488';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-5-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '422',
      '22',
      NULL,
      9.977733,
      '1433023',
      212.085205,
      2,
      0,
      1,
      '310011',
      3.884219,
      ' 3-16-1977',
      30.013093,
      68.292988,
      NULL,
      NULL,
      1.390840,
      0.379239,
      3.444179,
      1.554436,
      0.003776,
      0.846730,
      0,
      NULL,
      2.823963,
      0,
      3.458045,
      0,
      NULL,
      1.592038,
      1.242177,
      1,
      4,
      0.346940,
      1.889801,
      1,
      1,
      1,
      3.907298,
      NULL,
      3,
      NULL,
      0.415301,
      0.927587,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1.814657,
      1.844753,
      NULL,
      1.326021,
      0,
      1.106313,
      NULL,
      0,
      0.625679,
      3.587802,
      1,
      1,
      2,
      NULL,
      0,
      1.313044,
      2.683070,
      0,
      1,
      1.081608,
      NULL,
      0.123636,
      1,
      2,
      1,
      1,
      NULL,
      NULL,
      0.467949,
      NULL,
      NULL,
      0.949065,
      0,
      0.023061,
      0,
      0.285494,
      0,
      0.102531,
      1.906420,
      0.133341,
      1.336670,
      1.296166,
      1,
      0.138596,
      NULL,
      1.890709,
      1,
      1,
      1,
      0,
      NULL,
      0.823318,
      1.659325,
      1,
      1,
      1,
      NULL,
      0.565906,
      1,
      1,
      NULL,
      1.941000,
      0.233189,
      0,
      1,
      0,
      0.010730,
      NULL,
      0,
      1,
      NULL,
      NULL,
      5.891160,
      4,
      4.219548,
      0,
      NULL,
      1,
      1.826721,
      1.466774,
      NULL,
      NULL,
      6,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.254887,
      1,
      0,
      1,
      NULL,
      0.629281,
      1,
      1.373074,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.165709,
      2.081561,
      0.216749,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.503301,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.589250,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.853202,
      1,
      0.756400,
      1.445289,
      1.195472,
      3.567292,
      1,
      NULL,
      0,
      1,
      0,
      0,
      1,
      1,
      1.076590,
      0,
      NULL,
      1.865559,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.036160,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.508614,
      '40110',
      '',
      NULL,
      0,
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      '',
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


