set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8726488';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-8-31 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '340',
      '00',
      NULL,
      2.587917,
      '2313004',
      219,
      NULL,
      0,
      NULL,
      '333301',
      NULL,
      ' 0-14-1977',
      15,
      1,
      NULL,
      NULL,
      1,
      0,
      3.558718,
      0,
      NULL,
      NULL,
      1,
      1.251242,
      0,
      1.561780,
      NULL,
      0.259350,
      1.525983,
      1,
      0.319996,
      0.739437,
      3.009550,
      0.031443,
      2.245391,
      NULL,
      NULL,
      NULL,
      4,
      1,
      NULL,
      0.761638,
      1.152204,
      NULL,
      NULL,
      NULL,
      0.607037,
      NULL,
      NULL,
      6.551256,
      3,
      NULL,
      2,
      1,
      1,
      NULL,
      3,
      NULL,
      1,
      3,
      1,
      0,
      3.062542,
      0.486213,
      NULL,
      2,
      2,
      NULL,
      1.774335,
      NULL,
      1,
      0.544093,
      1,
      0,
      1,
      0.940672,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.198665,
      1.108027,
      NULL,
      0.150080,
      1.475553,
      1,
      0.963069,
      NULL,
      0.658646,
      0,
      0.566355,
      1,
      1,
      1,
      1,
      NULL,
      0.224846,
      1,
      NULL,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0.170064,
      1.237891,
      NULL,
      1.810198,
      1,
      3.354280,
      4.896118,
      5.768878,
      3,
      3,
      0,
      0,
      2,
      0,
      NULL,
      NULL,
      1.943896,
      NULL,
      NULL,
      5.788370,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.857899,
      NULL,
      0,
      0,
      1.953280,
      1.088732,
      1.379645,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.192341,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.422574,
      NULL,
      1.350673,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.357257,
      2,
      1.292310,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.562008,
      0.212617,
      NULL,
      0.202908,
      NULL,
      0.703701,
      0.157298,
      1.340832,
      0.615346,
      0,
      1.402332,
      1.810429,
      0,
      0,
      1,
      1,
      1,
      NULL,
      1.236836,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.969435,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.723685,
      '20000',
      '',
      NULL,
      1.371663,
      NULL,
      '',
      '',
      0,
      '',
      '',
      '',
      1.033032,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


