set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8726488';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-11-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '000',
      '22334303',
      27.732968,
      44.727163,
      '2201311',
      109,
      4,
      0.116893,
      1,
      '223002',
      0.770189,
      ' 0- 0-1977',
      NULL,
      30,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.407868,
      NULL,
      0.777775,
      1.125456,
      0,
      2,
      1,
      3.480034,
      NULL,
      0,
      1,
      0.474584,
      1,
      4.307123,
      1.488288,
      0.627449,
      1.357399,
      0,
      0.140740,
      5.766529,
      1,
      NULL,
      1,
      3,
      1.154468,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1.965193,
      3.915671,
      1,
      0.165846,
      3.155417,
      0,
      0,
      3.328140,
      1,
      1.833025,
      0.363163,
      0.135020,
      3.958595,
      0,
      3,
      1.537017,
      1,
      NULL,
      1.356381,
      1,
      3,
      0,
      0,
      0.711499,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0.713966,
      1,
      NULL,
      0.498989,
      NULL,
      0.744062,
      0,
      1,
      NULL,
      0,
      1,
      1,
      0,
      NULL,
      1.311758,
      1,
      NULL,
      0,
      NULL,
      0,
      1.493572,
      0,
      1,
      0,
      1.782275,
      1.484837,
      0,
      1.442258,
      0.455097,
      0.311491,
      1.692176,
      0,
      1.215304,
      0,
      1.845383,
      3,
      5,
      NULL,
      NULL,
      NULL,
      1.458247,
      NULL,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      3,
      1.561999,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.383864,
      1.702386,
      1,
      1,
      1,
      NULL,
      1.240877,
      1.280320,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.713769,
      1.690277,
      0.460016,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.351920,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.298795,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.809340,
      3,
      2.148811,
      0.467718,
      0,
      0.576362,
      NULL,
      1.833193,
      0,
      1.501627,
      1,
      1.610237,
      NULL,
      0,
      NULL,
      0,
      1.453395,
      1.795439,
      NULL,
      0.146110,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.637972,
      '33441',
      '',
      '',
      NULL,
      '',
      '',
      '',
      1.915257,
      '',
      '',
      '',
      0.416543,
      2,
      NULL,
      2,
      1.909661,
      2,
      0.480719,
      3,
      3);
commit;
end;
/


