set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8726488';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-4-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '423',
      '30100141',
      40.396382,
      30.576250,
      NULL,
      NULL,
      NULL,
      2.672737,
      3,
      '440332',
      4,
      ' 5-29-1981',
      32.467613,
      56.864254,
      0.079743,
      NULL,
      1.872410,
      NULL,
      1,
      0.789211,
      0,
      NULL,
      0.049138,
      1,
      1.709065,
      0,
      NULL,
      1,
      NULL,
      0.325105,
      0.318518,
      1,
      4,
      0,
      0,
      0.655618,
      0,
      0,
      2.637749,
      NULL,
      1.468156,
      1.499769,
      1,
      0.400913,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.876486,
      0.156476,
      0.409009,
      2,
      3,
      0,
      NULL,
      3,
      0,
      1.922358,
      NULL,
      0,
      NULL,
      2.173639,
      0,
      1,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      1.558999,
      1.075465,
      NULL,
      NULL,
      0.395105,
      NULL,
      NULL,
      0.050994,
      NULL,
      NULL,
      0,
      0.494075,
      1.211214,
      NULL,
      1.908914,
      1,
      0.694026,
      1,
      1,
      NULL,
      1.388706,
      NULL,
      0,
      NULL,
      1.080067,
      NULL,
      NULL,
      0.040541,
      0.134938,
      NULL,
      NULL,
      1.268689,
      0,
      NULL,
      2.175810,
      NULL,
      NULL,
      NULL,
      NULL,
      1.260135,
      0,
      0.106916,
      0.589240,
      1,
      3.126165,
      2.416312,
      1,
      1.122009,
      NULL,
      1.092051,
      1,
      4.132489,
      1,
      1,
      0.092606,
      NULL,
      NULL,
      NULL,
      1.089831,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.368813,
      1,
      1,
      NULL,
      1,
      1.221880,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      3,
      1,
      0.360619,
      2,
      2,
      NULL,
      0.180616,
      NULL,
      NULL,
      NULL,
      NULL,
      1.158608,
      1.310837,
      NULL,
      1,
      1,
      0.843351,
      NULL,
      NULL,
      NULL,
      0.693473,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.265264,
      NULL,
      0.861747,
      0.693891,
      NULL,
      0,
      1,
      1.887575,
      NULL,
      1.877377,
      NULL,
      0.887096,
      0.416691,
      1.131521,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      '21300',
      '',
      '',
      0,
      '',
      NULL,
      '',
      1.353648,
      '',
      '',
      '',
      2,
      2.070421,
      1,
      2.026688,
      1,
      NULL,
      1.058951,
      1,
      0);
commit;
end;
/


