set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8726488';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-9-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '330',
      '10402421',
      25,
      55.568071,
      '4110401',
      279,
      6,
      0,
      2,
      '430110',
      3.496951,
      NULL,
      28.866515,
      27.231397,
      NULL,
      NULL,
      0.812886,
      NULL,
      2.444731,
      1.752480,
      0.124359,
      1.778172,
      0,
      0,
      3.914894,
      NULL,
      4.787568,
      1.322117,
      1,
      0,
      NULL,
      1.343684,
      0.997845,
      0,
      1,
      1.350115,
      1,
      1.545070,
      0.906000,
      0,
      0.503893,
      NULL,
      1.435474,
      1.398272,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.193288,
      3.295179,
      NULL,
      NULL,
      1.626983,
      0,
      3.468433,
      3,
      1.237833,
      2,
      1,
      NULL,
      1,
      1.006610,
      NULL,
      0.056930,
      1.711381,
      3.952964,
      NULL,
      0,
      1,
      1.647274,
      3.231153,
      0,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      1.566214,
      0.487730,
      1.673672,
      1.142826,
      0,
      0,
      1,
      1,
      NULL,
      1,
      NULL,
      1.668433,
      1,
      0.320458,
      0,
      NULL,
      NULL,
      0.562472,
      1.340625,
      0.680738,
      1.928476,
      1,
      NULL,
      1.484193,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.191477,
      1,
      1,
      NULL,
      3,
      0.064215,
      0,
      1,
      5.183079,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.273612,
      NULL,
      NULL,
      9,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.843027,
      0.212607,
      1,
      0,
      NULL,
      1,
      1,
      0.149492,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.877562,
      NULL,
      NULL,
      NULL,
      NULL,
      1.480713,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0.844181,
      NULL,
      1,
      4,
      0.735365,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.603879,
      3,
      1,
      2,
      0.336964,
      1,
      1,
      1,
      1,
      NULL,
      1.161454,
      1.694161,
      1.469809,
      0,
      NULL,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '31143',
      '',
      '',
      0.305745,
      NULL,
      '',
      '',
      0.280497,
      NULL,
      '',
      '',
      0.952098,
      0,
      NULL,
      3,
      1.140245,
      2,
      0,
      NULL,
      0.869078);
commit;
end;
/


