set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8726488';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-4-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '32140020',
      47,
      51.494760,
      '1334320',
      72.712990,
      NULL,
      NULL,
      3,
      '430304',
      NULL,
      ' 3- 5-1996',
      14,
      54,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0.608867,
      NULL,
      NULL,
      0.779193,
      1,
      3.641950,
      0.724017,
      4.833385,
      0.421233,
      0,
      1,
      1.935492,
      1.652611,
      4.935279,
      0,
      0,
      0,
      1.935611,
      0,
      0.597265,
      1,
      0,
      1.125535,
      0.898451,
      1,
      NULL,
      NULL,
      0.140243,
      NULL,
      NULL,
      0,
      2,
      1.732970,
      0.539575,
      1.692358,
      0.053128,
      NULL,
      NULL,
      1,
      0,
      0,
      1,
      1,
      3,
      NULL,
      0.886536,
      NULL,
      1,
      2,
      1,
      1.712817,
      1.905295,
      1.260145,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      1.065983,
      0.155967,
      0.654227,
      0,
      1.952575,
      0,
      0,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      0.091532,
      NULL,
      0,
      1,
      NULL,
      0.770452,
      0,
      NULL,
      1,
      0.889315,
      1.785588,
      1.885469,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.321253,
      0,
      0,
      1,
      2,
      0.309077,
      0.575914,
      1.179277,
      5.466272,
      1,
      0.544857,
      1.249810,
      1.771342,
      1,
      1,
      0,
      NULL,
      NULL,
      9,
      0.375484,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      0,
      0.350483,
      NULL,
      0.815542,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.380133,
      NULL,
      NULL,
      NULL,
      NULL,
      1.899867,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.515292,
      0,
      1.805037,
      NULL,
      NULL,
      NULL,
      0.994431,
      0.484210,
      0.672022,
      5.498272,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.297368,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      0,
      NULL,
      NULL,
      0.670785,
      NULL,
      NULL,
      0.588458,
      0.551929,
      1,
      0,
      1.681131,
      0.019551,
      1.657048,
      1.283677,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      '30034',
      '',
      NULL,
      0.504762,
      '',
      '',
      '',
      0,
      '',
      NULL,
      '',
      4,
      2.078146,
      1,
      3.663314,
      3,
      3.662367,
      1.021075,
      0.467861,
      2.297454);
commit;
end;
/


