set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8726488';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-9-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '022',
      '01343124',
      20.815571,
      70.782223,
      '4120313',
      56.433336,
      2,
      0,
      2,
      '301302',
      5,
      NULL,
      0.652461,
      NULL,
      0,
      NULL,
      1,
      0,
      1,
      NULL,
      1.960488,
      1.683731,
      0,
      NULL,
      NULL,
      1,
      3,
      NULL,
      1,
      0.970415,
      1.130532,
      1,
      5,
      0.778013,
      1.868802,
      NULL,
      0,
      1,
      3,
      1,
      0.877275,
      0,
      2.205659,
      1.915870,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      4.176011,
      0,
      3.913292,
      1.368245,
      0.564166,
      3,
      2,
      0,
      NULL,
      0.391247,
      0,
      0,
      3,
      0,
      1.149488,
      1.675034,
      3,
      2,
      0.795350,
      1,
      1,
      3.096626,
      0,
      0,
      0.836631,
      0.274693,
      NULL,
      NULL,
      0.974373,
      NULL,
      NULL,
      1.823529,
      NULL,
      NULL,
      1,
      0,
      1,
      0,
      0,
      0,
      0.895236,
      NULL,
      1,
      1,
      NULL,
      0,
      1.903447,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      0.999949,
      1.712662,
      0,
      0.593805,
      NULL,
      1.034511,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.414339,
      0,
      1,
      0.600134,
      NULL,
      1.483740,
      NULL,
      1.111972,
      3,
      2.937706,
      2.588251,
      NULL,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.671660,
      0.870343,
      1,
      NULL,
      NULL,
      1.051235,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.999485,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.059111,
      3.819593,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      0.293515,
      NULL,
      0.259513,
      NULL,
      NULL,
      NULL,
      0,
      0.565988,
      0.783803,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.032676,
      2.206348,
      NULL,
      1,
      1,
      0.507959,
      1,
      0,
      0.576737,
      0.569500,
      1.010034,
      0,
      NULL,
      0.684229,
      0,
      0,
      1,
      0.186021,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      '13442',
      '',
      '',
      0,
      '',
      '',
      NULL,
      1,
      '',
      '',
      NULL,
      NULL,
      1,
      1.776198,
      2,
      2,
      0.519887,
      2.900945,
      3.632461,
      NULL);
commit;
end;
/


