set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8726488';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-3-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '132',
      '32112324',
      58,
      29,
      NULL,
      134.233833,
      1,
      2.806937,
      3,
      '202140',
      3,
      NULL,
      29,
      NULL,
      1,
      NULL,
      NULL,
      0.952387,
      1.804432,
      NULL,
      0,
      NULL,
      NULL,
      0.496495,
      2.575750,
      0.669473,
      4.553195,
      1.249472,
      0.136769,
      1,
      0,
      1.205316,
      5.495081,
      1.161640,
      NULL,
      0,
      0,
      0.635285,
      3,
      0,
      NULL,
      1,
      0,
      0.431984,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      7.600384,
      5.112797,
      1.036515,
      NULL,
      1.779911,
      0.657666,
      3.317592,
      1.242488,
      1.156457,
      1,
      3.345495,
      0,
      1,
      2,
      NULL,
      0,
      0.763394,
      1,
      1,
      0,
      0.482349,
      1.342544,
      4.760201,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      0.596758,
      NULL,
      1,
      1,
      NULL,
      1.379156,
      0,
      1.697270,
      1.731785,
      0,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      1,
      0.549511,
      NULL,
      0,
      1.056840,
      1.246164,
      1.351957,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.802541,
      1,
      0,
      0,
      4.836671,
      1,
      4,
      1,
      7.317294,
      0.531404,
      5,
      4.487830,
      1.135070,
      1,
      1.635894,
      0.868142,
      NULL,
      NULL,
      9,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      1.491453,
      1.791893,
      0.155434,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.202980,
      3,
      0.777176,
      NULL,
      NULL,
      NULL,
      5,
      1.344562,
      0.081497,
      1.398433,
      0.758567,
      0,
      1.602190,
      NULL,
      NULL,
      NULL,
      1,
      3.523312,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1.507096,
      NULL,
      1,
      1,
      1,
      0,
      0,
      1.770181,
      0,
      0.813143,
      1,
      0,
      0,
      0.038071,
      0.261456,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      '24022',
      '',
      '',
      1,
      '',
      '',
      '',
      1.524129,
      '',
      '',
      '',
      NULL,
      2,
      3.325782,
      1.758746,
      3.812305,
      3,
      NULL,
      NULL,
      3.911864);
commit;
end;
/


