set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8726488';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-10-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '34243040',
      71,
      46,
      NULL,
      210,
      5,
      0,
      2,
      '314122',
      1,
      NULL,
      NULL,
      NULL,
      0.942268,
      NULL,
      1.924235,
      NULL,
      2,
      0.112052,
      0.673340,
      NULL,
      0.061408,
      0.907424,
      3.224222,
      1,
      1,
      1.422272,
      0,
      1.449593,
      1.378670,
      0.303386,
      2,
      NULL,
      1,
      1.308133,
      NULL,
      0.446636,
      3,
      0,
      NULL,
      NULL,
      0,
      0.441356,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.767199,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.698261,
      NULL,
      0.475301,
      1.774982,
      NULL,
      1.184642,
      0.730392,
      NULL,
      NULL,
      1,
      0.670917,
      0,
      1,
      0,
      NULL,
      NULL,
      1.541546,
      0.269152,
      NULL,
      1,
      0,
      1,
      0,
      1,
      0.605487,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0.174866,
      1.548059,
      0,
      1.567731,
      1,
      1.433723,
      NULL,
      1.181145,
      NULL,
      NULL,
      2.594535,
      0,
      3.494421,
      NULL,
      1,
      1.829930,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.760178,
      0,
      1,
      0,
      0.836043,
      0,
      1.560476,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.000854,
      NULL,
      NULL,
      NULL,
      NULL,
      1.836329,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1.913595,
      1,
      NULL,
      NULL,
      NULL,
      5,
      1,
      1,
      5.277757,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.530309,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.017665,
      1,
      1,
      0.548380,
      1,
      0.399763,
      NULL,
      1,
      0,
      3,
      0,
      0.448708,
      0.819750,
      1.524820,
      NULL,
      0,
      1.339093,
      1,
      0,
      1.795737,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.863428,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      '24414',
      '',
      '',
      1.594482,
      '',
      '',
      '',
      1.566716,
      '',
      NULL,
      '',
      3.517448,
      2.229456,
      NULL,
      NULL,
      4.868940,
      NULL,
      3,
      3,
      3);
commit;
end;
/


