set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8726488';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-4-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '024',
      '40403443',
      8.721625,
      27,
      '1041014',
      268.445790,
      4,
      1.449607,
      3,
      '424011',
      NULL,
      NULL,
      36.079747,
      NULL,
      1,
      NULL,
      0,
      1.936568,
      1,
      0.340784,
      1,
      0,
      1,
      1.618559,
      1,
      0,
      0.094933,
      0.369134,
      1.024043,
      NULL,
      0.608711,
      0,
      NULL,
      0.805103,
      1.778003,
      1.368300,
      1.783771,
      NULL,
      4,
      0,
      NULL,
      NULL,
      2.539812,
      1.966035,
      NULL,
      NULL,
      1.750271,
      NULL,
      NULL,
      1.548780,
      1.859122,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.442093,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.918845,
      0.709781,
      1,
      0.308452,
      1,
      0.258082,
      1.550460,
      0,
      0,
      NULL,
      1,
      0.340932,
      0.376185,
      0,
      1,
      NULL,
      1,
      NULL,
      1,
      0.618057,
      1,
      0,
      1,
      0.180728,
      1.781729,
      3.311012,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.851538,
      2.576258,
      1,
      NULL,
      NULL,
      4.746640,
      4.603646,
      3.697973,
      4,
      3,
      NULL,
      1,
      0.097187,
      1,
      0,
      NULL,
      NULL,
      NULL,
      4,
      1.420839,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      0.422900,
      1.372934,
      1.400300,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.229486,
      1.286333,
      NULL,
      NULL,
      NULL,
      0.988866,
      1,
      1,
      0,
      1.766651,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.115973,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.868448,
      1.292441,
      0,
      NULL,
      2.663178,
      0,
      0.088788,
      1,
      0,
      2,
      NULL,
      1,
      1.904577,
      1,
      1.168067,
      0,
      0.869679,
      0,
      1.953261,
      0.952671,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.776701,
      NULL,
      '',
      '',
      0,
      '',
      '',
      '',
      0.806358,
      '',
      '',
      '',
      2.766286,
      3.746286,
      0.091106,
      3,
      NULL,
      3.195335,
      NULL,
      NULL,
      0);
commit;
end;
/


