set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8726488';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-6-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4413',
      '41120333',
      23.328089,
      22.789499,
      '3401044',
      115,
      NULL,
      2,
      3,
      NULL,
      2.215199,
      ' 5-11-1988',
      5,
      22.923966,
      1,
      NULL,
      1.504446,
      0,
      0,
      NULL,
      0.938808,
      0,
      1,
      1.727556,
      2.920687,
      1.377565,
      1.476637,
      NULL,
      0,
      1.011259,
      NULL,
      0.780352,
      5,
      0,
      0.202886,
      0,
      1.268047,
      1.549691,
      2,
      0,
      2,
      0,
      1.566004,
      NULL,
      NULL,
      NULL,
      1.137932,
      NULL,
      NULL,
      1.560883,
      0.670321,
      1.151860,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.095534,
      0,
      0.320129,
      1.435005,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.325810,
      1,
      NULL,
      NULL,
      1.455696,
      NULL,
      1,
      0,
      1,
      NULL,
      1.569666,
      1,
      NULL,
      0,
      1.342760,
      1.167605,
      0.254527,
      0,
      1,
      NULL,
      1.026867,
      0,
      NULL,
      0,
      0.579312,
      1,
      1.682618,
      0.922846,
      NULL,
      NULL,
      NULL,
      NULL,
      0.476814,
      4.078978,
      NULL,
      1.562191,
      0.756930,
      1,
      4.226783,
      NULL,
      NULL,
      4,
      0.567053,
      2.362348,
      NULL,
      1.665043,
      NULL,
      0.107135,
      0,
      NULL,
      NULL,
      6,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.181752,
      0,
      NULL,
      NULL,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      2,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.578966,
      3,
      1.402927,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.690041,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.007088,
      3,
      1.919870,
      NULL,
      1.652194,
      1,
      NULL,
      0.034021,
      3.195868,
      0.673824,
      NULL,
      NULL,
      0.773775,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.887977,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.049425,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      0.759927,
      3.847707,
      1.123840,
      5.528262,
      2.470198,
      NULL,
      0.070152,
      3.192725,
      3.662534);
commit;
end;
/


