set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8726488';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-10-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3303',
      NULL,
      53.283535,
      16,
      NULL,
      65,
      NULL,
      NULL,
      0,
      '010134',
      0.945223,
      '10-24-2001',
      23,
      35.905729,
      0,
      NULL,
      NULL,
      NULL,
      3,
      1.953448,
      1,
      0,
      1,
      NULL,
      NULL,
      0,
      5,
      NULL,
      NULL,
      0,
      0,
      1.709280,
      NULL,
      0.183591,
      1,
      0.840884,
      NULL,
      0.557250,
      NULL,
      1,
      3.291765,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.583376,
      0,
      0,
      NULL,
      NULL,
      0,
      3.386744,
      NULL,
      0.390545,
      NULL,
      NULL,
      2.062082,
      NULL,
      1.464672,
      NULL,
      1.867874,
      0.466098,
      0.904643,
      1.435819,
      0,
      NULL,
      0,
      2,
      0,
      0.346564,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.359437,
      0,
      1,
      1,
      1,
      1,
      0,
      0.424411,
      NULL,
      0.262204,
      0.537742,
      1.798203,
      0.275458,
      1.178616,
      1,
      1.030501,
      1.640011,
      NULL,
      0.193986,
      1.161377,
      0.283532,
      1.224766,
      1,
      0.984717,
      1.838923,
      0.287874,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      1.462354,
      0,
      0,
      0,
      2.110264,
      NULL,
      1,
      1.562935,
      0.511767,
      1.327302,
      3.333015,
      0.950346,
      1,
      1.812122,
      1.186911,
      NULL,
      NULL,
      4,
      1.365054,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.553086,
      1.132135,
      1,
      1,
      1.679871,
      0.471633,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.114259,
      1.031164,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1.584846,
      1.579443,
      5,
      0.997777,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.135984,
      1.393701,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.172274,
      NULL,
      NULL,
      3.471126,
      1.213104,
      0.098562,
      NULL,
      NULL,
      0,
      2.688702,
      1,
      0.448527,
      0.930990,
      0.926273,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      '',
      NULL,
      1,
      NULL,
      '',
      NULL,
      0,
      '',
      '',
      '',
      3.170248,
      0,
      0.148907,
      2.002647,
      3.414227,
      0.814344,
      1,
      NULL,
      1);
commit;
end;
/


