set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8726488';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-5-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0242',
      '22431432',
      NULL,
      42.807326,
      '4322124',
      NULL,
      2,
      NULL,
      0,
      '021003',
      1.749769,
      ' 5- 6-1984',
      15,
      5,
      1,
      NULL,
      NULL,
      1,
      1.865458,
      1,
      0,
      1.588129,
      1.150842,
      1,
      1.853092,
      NULL,
      2.738292,
      1,
      1,
      0,
      1,
      0.277784,
      1,
      1,
      1.902137,
      NULL,
      0.319264,
      1.925033,
      0.082161,
      1,
      0,
      2,
      3.608788,
      1.302179,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5,
      5,
      3.902930,
      NULL,
      1.115351,
      0,
      1,
      NULL,
      1,
      2,
      0.941238,
      NULL,
      1.559119,
      3,
      NULL,
      1,
      2.300935,
      1,
      1,
      1,
      1.161116,
      1.303859,
      3.110617,
      0,
      0,
      2.672691,
      0,
      NULL,
      NULL,
      1.770920,
      NULL,
      NULL,
      1,
      0.530213,
      NULL,
      1.870907,
      0.270857,
      0,
      0,
      NULL,
      1,
      1.176998,
      1,
      NULL,
      1.468432,
      0.568928,
      0.269325,
      0.891564,
      1.512627,
      1,
      NULL,
      NULL,
      1,
      1.764505,
      0,
      1,
      0,
      0.328347,
      0.414773,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      2.662144,
      5,
      2.176879,
      0,
      0.067784,
      NULL,
      0.702903,
      4.137527,
      0.054354,
      2.322517,
      3.160231,
      0.840617,
      4,
      NULL,
      1.787323,
      0.988394,
      1.688587,
      NULL,
      NULL,
      0,
      1.861609,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      1.319383,
      0,
      0.941818,
      0.474622,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.241988,
      0.314912,
      0,
      NULL,
      NULL,
      NULL,
      0.846732,
      1,
      1,
      NULL,
      0,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.281466,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3.888043,
      2,
      0.458594,
      1,
      1.625497,
      2.264067,
      1,
      3.374588,
      0.978160,
      NULL,
      NULL,
      0.525943,
      0.889545,
      1.998390,
      NULL,
      0,
      1.407371,
      1.490733,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      '13010',
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      0,
      '',
      '',
      '',
      4.459724,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.599546,
      3.908074,
      3);
commit;
end;
/


