set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9409102';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-4-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '3',
      NULL,
      NULL,
      '4314423',
      12,
      NULL,
      3.351158,
      2,
      '211012',
      2.187538,
      '10-15-1974',
      56,
      NULL,
      1,
      NULL,
      3.027356,
      0,
      0.362849,
      0.975979,
      2,
      NULL,
      1,
      1.364781,
      NULL,
      1.219441,
      4.861552,
      0,
      0,
      6.434065,
      7,
      NULL,
      NULL,
      0.692219,
      NULL,
      NULL,
      NULL,
      NULL,
      1.538320,
      0,
      1,
      2,
      3,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      1.046145,
      3,
      0.460214,
      NULL,
      0,
      0.443304,
      1,
      1.586217,
      NULL,
      2,
      0,
      0,
      0,
      2.981361,
      NULL,
      0.900906,
      0,
      0,
      0,
      3,
      4.489047,
      0,
      1,
      0.684673,
      0,
      NULL,
      NULL,
      1.586765,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.520603,
      0.777216,
      0.502943,
      0.886049,
      0,
      1,
      4,
      0,
      0.844539,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0.354454,
      1.119424,
      NULL,
      1.517313,
      1.195241,
      NULL,
      0,
      0,
      1.987354,
      1.986471,
      0.426613,
      0.692865,
      1.972873,
      0.252616,
      0,
      NULL,
      1,
      2,
      1.462116,
      NULL,
      6,
      0,
      4.570567,
      NULL,
      2,
      0.346766,
      4,
      4,
      0.911097,
      NULL,
      5.691239,
      NULL,
      0,
      1,
      NULL,
      5.826168,
      NULL,
      0.883107,
      NULL,
      0.002355,
      1.828892,
      1.995820,
      0,
      0,
      2,
      1,
      1,
      1.602455,
      2.576126,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.262338,
      NULL,
      1,
      2,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.913687,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.976736,
      1,
      NULL,
      NULL,
      1.262717,
      3.680933,
      0.235365,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.141738,
      3.494924,
      0.957653,
      1.384185,
      3,
      1.586898,
      1.147935,
      1.159926,
      0.232121,
      3.853379,
      1.240054,
      1.570904,
      1,
      1,
      1.223491,
      NULL,
      0.235540,
      0.812665,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.360732,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.385076,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.122757,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      0,
      NULL,
      1.439073,
      1.645723,
      NULL,
      2,
      1,
      '34002',
      '',
      '',
      1,
      '',
      '',
      NULL,
      1,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


