set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9409102';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-10-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '1',
      NULL,
      NULL,
      '2303211',
      19.210570,
      NULL,
      0,
      3,
      '330011',
      0,
      ' 1- 8-1999',
      4.500553,
      NULL,
      0.094225,
      NULL,
      0.534363,
      0,
      1,
      1,
      2,
      0.057004,
      0.935999,
      1.240960,
      0.583214,
      1,
      NULL,
      1,
      0,
      0.335771,
      1.615618,
      1,
      3.262795,
      NULL,
      1.773587,
      1,
      2,
      1.890767,
      NULL,
      0,
      2.001995,
      1,
      1,
      0.226880,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.736951,
      1,
      0.367742,
      0.258323,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.193733,
      1.700248,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.423137,
      1.231853,
      0.984789,
      1.313303,
      1,
      1.662058,
      1.719234,
      1.314105,
      1,
      NULL,
      0.486616,
      0,
      0.480845,
      0.715445,
      1,
      NULL,
      1.423660,
      NULL,
      1.829249,
      NULL,
      0,
      0.428664,
      1.898399,
      0.140034,
      1,
      NULL,
      0,
      0,
      1,
      1.934331,
      0.432659,
      0,
      1,
      1,
      0.413223,
      1.059360,
      0.932101,
      NULL,
      1.094984,
      5.826928,
      1.523720,
      1,
      1.541657,
      NULL,
      1.848792,
      NULL,
      1,
      0.003035,
      1.195941,
      NULL,
      NULL,
      1.972363,
      1.732365,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.456282,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.607244,
      NULL,
      NULL,
      NULL,
      NULL,
      0.474503,
      0,
      1.974985,
      3,
      NULL,
      2,
      NULL,
      1.843086,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.535454,
      NULL,
      1.462007,
      0.181609,
      1,
      1.292747,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.820689,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.556460,
      0.079354,
      NULL,
      1,
      0,
      1.658905,
      1.019594,
      1.927745,
      2.059848,
      0.516330,
      NULL,
      1.204627,
      1.853027,
      0,
      1,
      1,
      0.847994,
      0,
      0.791287,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.485460,
      1,
      NULL,
      1,
      0.602532,
      0.213797,
      1.798667,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.961918,
      3,
      3,
      NULL,
      0,
      0.819575,
      0,
      2,
      4,
      '44032',
      '34142',
      NULL,
      0.710984,
      '',
      '',
      '',
      0.761449,
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


