set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9409102';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-4-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '1',
      NULL,
      NULL,
      '1142211',
      44,
      1,
      0,
      3,
      NULL,
      0.980812,
      ' 0- 0-1995',
      53.802234,
      NULL,
      0,
      NULL,
      2,
      1.989995,
      1.557555,
      1.021753,
      NULL,
      NULL,
      3,
      0.829706,
      1,
      0,
      1,
      1.905151,
      0.938333,
      1.632523,
      0,
      0,
      1,
      NULL,
      5,
      1,
      5,
      1.304849,
      5.462672,
      2,
      0,
      NULL,
      0.731184,
      1.405112,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.585547,
      1,
      3.871065,
      2,
      1.511661,
      0.107533,
      0,
      NULL,
      0,
      0.785683,
      1.711658,
      2.493480,
      3,
      NULL,
      0.149265,
      0.852584,
      1.635268,
      0.985536,
      1.073765,
      1.093772,
      0.198939,
      NULL,
      NULL,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.175827,
      0,
      1,
      NULL,
      1,
      1.452087,
      2,
      0,
      NULL,
      1,
      0,
      1.968071,
      0,
      2.594232,
      0,
      1.044004,
      1.246202,
      NULL,
      1.314200,
      NULL,
      1.429359,
      1.054658,
      NULL,
      0,
      NULL,
      1,
      1,
      0,
      1.228417,
      1,
      0,
      NULL,
      NULL,
      NULL,
      3.215569,
      1,
      NULL,
      2,
      6,
      3,
      NULL,
      1,
      NULL,
      4.753633,
      3,
      3,
      0,
      2.813640,
      3,
      1,
      1.491757,
      0.095260,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.661688,
      1.247380,
      0,
      2,
      0.329958,
      1,
      1.050156,
      0.380151,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.509965,
      NULL,
      1.191751,
      0.661681,
      1.889148,
      1.317949,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.125391,
      2,
      0.889307,
      NULL,
      NULL,
      NULL,
      1,
      1.335023,
      0.078717,
      NULL,
      NULL,
      1,
      3,
      1.410100,
      NULL,
      NULL,
      3,
      3.817316,
      0.895657,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      3,
      0,
      1,
      0,
      2,
      0,
      2.585613,
      0,
      0.593834,
      0.018304,
      1,
      1,
      0.991590,
      NULL,
      1.595441,
      1.968572,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.891391,
      0.195808,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.578388,
      NULL,
      0.316483,
      NULL,
      0,
      0.851089,
      0.935573,
      1.594042,
      2.465868,
      1.343477,
      0.054113,
      NULL,
      0,
      NULL,
      0.696394,
      0.839555,
      1.193946,
      NULL,
      NULL,
      NULL,
      NULL,
      0.263931,
      NULL,
      1,
      NULL,
      NULL,
      2.365522,
      2.792899,
      2.321154,
      1.535690,
      0,
      0,
      NULL,
      0,
      0.972813,
      '04141',
      '11242',
      NULL,
      1,
      '',
      '',
      '',
      NULL,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


