set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9409102';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-9-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '431',
      '03',
      24,
      3,
      '4342122',
      12.930025,
      NULL,
      0,
      1,
      '134333',
      1,
      ' 3-10-1998',
      25.375567,
      43,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0.449768,
      1.049934,
      3,
      2.474988,
      NULL,
      0,
      0,
      1,
      1,
      0,
      0,
      1,
      1.050759,
      0.048850,
      0,
      NULL,
      0.364023,
      2.249147,
      1,
      6.262951,
      1,
      3,
      0.023070,
      2.166762,
      1.113650,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      8,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      4,
      2,
      1,
      NULL,
      0,
      1,
      1,
      1.717556,
      NULL,
      1.923506,
      1,
      1.894793,
      4.700418,
      1.854250,
      NULL,
      NULL,
      1.176774,
      1.993686,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.328107,
      0,
      0.742298,
      NULL,
      2,
      NULL,
      1,
      3.208238,
      2,
      NULL,
      4.870288,
      1.319244,
      3,
      1.251886,
      3.691098,
      7.570051,
      6.687425,
      0.399263,
      1,
      0,
      1.041677,
      1.888587,
      1.644583,
      1.898177,
      NULL,
      3.039622,
      NULL,
      3.197915,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.754022,
      1,
      1,
      0,
      0,
      1.494588,
      NULL,
      0.194961,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.879178,
      NULL,
      5,
      1.216103,
      NULL,
      0,
      1.356913,
      1.523626,
      NULL,
      3,
      0,
      NULL,
      0,
      2.889530,
      0,
      1,
      0.649724,
      1,
      3.894833,
      1,
      6.688752,
      4,
      NULL,
      0.733796,
      0,
      NULL,
      NULL,
      NULL,
      9,
      1,
      5.154975,
      3,
      1.170386,
      9,
      1.911648,
      NULL,
      3.831247,
      3.438093,
      NULL,
      0.754280,
      0.091509,
      1.180073,
      0.116213,
      NULL,
      1,
      0,
      3.469101,
      0.025406,
      NULL,
      0,
      1.213457,
      0.495403,
      1.726112,
      0.404431,
      NULL,
      0.887480,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.499844,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.411337,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.490848,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.463276,
      2.542152,
      1,
      0,
      2.530369,
      1,
      0.311228,
      NULL,
      1.147579,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.781777,
      3.906852,
      8,
      2.823226,
      0.866847,
      1,
      0,
      2.052057,
      '32330',
      '21042',
      '44442',
      NULL,
      '',
      '',
      '',
      NULL,
      '',
      '',
      NULL,
      2.123968,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


