set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9409102';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-5-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '24',
      33.705455,
      NULL,
      '1204034',
      NULL,
      3,
      0.334827,
      2,
      '142400',
      NULL,
      ' 2-15-1996',
      NULL,
      33.561377,
      0,
      NULL,
      2.747771,
      0.033679,
      NULL,
      1.837551,
      1.775686,
      0.763230,
      1.612685,
      NULL,
      3,
      1,
      0.104051,
      NULL,
      0,
      NULL,
      2.564768,
      1.701228,
      NULL,
      1,
      5.584985,
      1,
      0.893165,
      NULL,
      2,
      0,
      5.616340,
      0,
      2.048758,
      1.166625,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.149960,
      1,
      1,
      0.594947,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.983204,
      1,
      1.768181,
      0.498988,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.074704,
      NULL,
      0,
      3,
      1,
      0.959797,
      1,
      1,
      0.698289,
      NULL,
      NULL,
      1.764883,
      0,
      NULL,
      0,
      1.334292,
      0.321330,
      0,
      NULL,
      0.947096,
      1,
      0.900874,
      0,
      1.086398,
      0.599222,
      0.909908,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      0.240959,
      2,
      0.548060,
      1,
      NULL,
      5,
      0,
      2.529072,
      0.904827,
      1.179995,
      2.268188,
      0.698506,
      1.628053,
      0,
      1.451714,
      1.929805,
      1,
      1.116323,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.456670,
      2,
      0,
      2,
      1.990221,
      1,
      NULL,
      0.509759,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      2.616800,
      1.183327,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.969629,
      1,
      0,
      4.074855,
      0,
      0,
      NULL,
      0.947552,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.289040,
      1,
      NULL,
      0.915523,
      1,
      0,
      1.172611,
      0,
      2.905853,
      1.849509,
      1.888892,
      1,
      1,
      1.210884,
      1.198803,
      1.579116,
      0.603836,
      0,
      2,
      NULL,
      1.057167,
      1.267782,
      1.502580,
      NULL,
      0.190456,
      1.664387,
      NULL,
      0,
      1.866239,
      0.132148,
      0,
      0.774377,
      1,
      1.675188,
      1.504496,
      0,
      0.798018,
      1.312384,
      1,
      1,
      0.656241,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.307202,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.412022,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.275816,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.751191,
      NULL,
      2.673311,
      1,
      0.100597,
      2,
      1.123214,
      '30320',
      '40140',
      '',
      0,
      NULL,
      NULL,
      '',
      NULL,
      '',
      '',
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


