set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9409102';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-10-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '01',
      4,
      NULL,
      '4134132',
      28,
      2,
      1,
      NULL,
      '304344',
      0.831214,
      ' 3-11-1985',
      NULL,
      53.077943,
      0.619090,
      NULL,
      2.137050,
      1,
      0,
      1.130898,
      NULL,
      0,
      NULL,
      1,
      3.953850,
      NULL,
      4.277853,
      1,
      1,
      5.167746,
      5.891250,
      NULL,
      2.371297,
      1.607263,
      3.994475,
      NULL,
      3,
      3,
      5.400385,
      0,
      1.097037,
      NULL,
      0,
      1.919926,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.344154,
      1,
      NULL,
      1.480703,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.017663,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.574318,
      0,
      NULL,
      NULL,
      4.953838,
      0,
      1.590786,
      1,
      0.143276,
      NULL,
      4,
      0.568480,
      0,
      NULL,
      0,
      1.418691,
      0,
      NULL,
      0,
      NULL,
      1.687531,
      1,
      0,
      3,
      1.268398,
      0,
      0,
      0.782683,
      3.921856,
      0,
      0,
      NULL,
      1,
      0,
      NULL,
      1.357636,
      NULL,
      1,
      0,
      NULL,
      4,
      1,
      1.277168,
      4.853554,
      1,
      NULL,
      0,
      1.952934,
      0,
      1.109298,
      0.533215,
      0,
      2.860280,
      NULL,
      2,
      2.881398,
      NULL,
      NULL,
      1.441579,
      4,
      0,
      1,
      1,
      1.605608,
      4,
      1.485076,
      1,
      1,
      NULL,
      NULL,
      NULL,
      3.850192,
      NULL,
      3.751128,
      NULL,
      1,
      2.227269,
      2.876614,
      0.894072,
      0.497951,
      0.700178,
      NULL,
      7,
      2,
      0,
      NULL,
      NULL,
      NULL,
      3.824023,
      1.979533,
      4,
      NULL,
      1,
      NULL,
      3.779339,
      0.817263,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.670964,
      3,
      NULL,
      3.494206,
      NULL,
      1,
      1,
      NULL,
      0.195429,
      3,
      0,
      0.483735,
      2,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0.423110,
      0,
      1,
      0.415864,
      0.929287,
      0.490096,
      0,
      1.871648,
      NULL,
      0,
      0,
      0.478665,
      0,
      1,
      0.217827,
      1,
      NULL,
      0.667070,
      1,
      1.951007,
      0,
      NULL,
      1,
      0,
      0.721528,
      1.549439,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.421162,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.790969,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.962505,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.551514,
      NULL,
      NULL,
      NULL,
      NULL,
      0.357814,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      0,
      3,
      2.264684,
      1.745612,
      NULL,
      2,
      NULL,
      '13032',
      '04043',
      '',
      1,
      '',
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      4.420950,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


