set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9409102';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-4-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '044',
      '44',
      20,
      1,
      '1311422',
      62,
      NULL,
      1.623761,
      1,
      '432400',
      NULL,
      ' 9-14-1976',
      30,
      29.746804,
      0,
      NULL,
      NULL,
      1.196026,
      NULL,
      1.729388,
      0.972323,
      1.148918,
      2.758813,
      NULL,
      0,
      1.686016,
      3,
      1.618398,
      0.929915,
      NULL,
      5,
      1.190341,
      5.481983,
      1,
      NULL,
      1.068725,
      4,
      0,
      2,
      0,
      4.365063,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.547493,
      NULL,
      NULL,
      NULL,
      1,
      0.914362,
      0.014431,
      NULL,
      1,
      3,
      3,
      1.287719,
      0.876687,
      1.884273,
      0.636855,
      3,
      1,
      0.256245,
      1,
      0.870159,
      0.291230,
      0.845292,
      5,
      3.865094,
      0,
      4,
      0,
      1,
      NULL,
      1.675813,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.381008,
      0,
      NULL,
      NULL,
      1,
      0,
      5.221503,
      1,
      1,
      NULL,
      NULL,
      1,
      0.435509,
      2,
      0,
      1.342951,
      NULL,
      1.438211,
      1,
      NULL,
      1,
      0.461246,
      NULL,
      NULL,
      0.518742,
      1.440641,
      1,
      0.526559,
      3,
      NULL,
      1.407281,
      1.800791,
      1.634095,
      NULL,
      1,
      0.019788,
      6.004955,
      3.307666,
      3.947049,
      3,
      5,
      0,
      0.105041,
      1,
      1,
      0,
      5.865853,
      NULL,
      NULL,
      0,
      0,
      3.506163,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5,
      2,
      0,
      1.590184,
      0.336205,
      0.320652,
      1.762561,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      4.205610,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.593091,
      NULL,
      1.333736,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      NULL,
      3.805483,
      1,
      2,
      0.886495,
      NULL,
      NULL,
      1.295284,
      0.677972,
      1.362059,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      1.370305,
      1,
      2.678031,
      NULL,
      1.799357,
      1.410031,
      1.865011,
      NULL,
      1.556479,
      0,
      0.204074,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.430790,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.770690,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.776729,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      3.657259,
      9.033778,
      NULL,
      NULL,
      NULL,
      1,
      5.417761,
      '04441',
      NULL,
      '',
      1.327825,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      1.848062,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


