set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9409102';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-11-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '133',
      '11231422',
      NULL,
      48,
      '1432320',
      63,
      NULL,
      NULL,
      2,
      '222124',
      2.288121,
      NULL,
      49,
      NULL,
      1,
      NULL,
      1.687499,
      1,
      NULL,
      0,
      1.818749,
      NULL,
      1.880316,
      NULL,
      0.247824,
      0.556936,
      0,
      1,
      0,
      NULL,
      0.074032,
      0,
      NULL,
      1,
      0,
      0,
      0.846638,
      1.183479,
      1,
      1,
      5,
      0,
      1.059551,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.342035,
      NULL,
      0.409007,
      0.604990,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.374167,
      1.790967,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.785794,
      0.144368,
      3.749363,
      0,
      0,
      0,
      0.608941,
      NULL,
      0.147923,
      0,
      NULL,
      1,
      1.756728,
      0.529914,
      0,
      1.054417,
      0.332422,
      NULL,
      1.691561,
      NULL,
      NULL,
      0,
      1.349827,
      0.388651,
      0,
      1.127778,
      0,
      1.751849,
      NULL,
      1,
      0.634063,
      0,
      0,
      1.095942,
      7,
      4.288490,
      3.207304,
      0.503672,
      2,
      NULL,
      1.953035,
      0.606600,
      NULL,
      1.902795,
      0,
      1.654012,
      0,
      1,
      1,
      9,
      1.000909,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.388165,
      NULL,
      1,
      0,
      NULL,
      1.963059,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.977380,
      NULL,
      NULL,
      NULL,
      NULL,
      1.783935,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.204818,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.274739,
      0,
      0.551956,
      2,
      5,
      1,
      NULL,
      NULL,
      NULL,
      1.208464,
      0.358159,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.138443,
      1.356039,
      1.880181,
      0.326861,
      0,
      1.938053,
      1,
      0,
      0.150857,
      0.882532,
      0.964713,
      NULL,
      1,
      0.652632,
      NULL,
      0.365432,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      '',
      1,
      '',
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      5,
      2,
      1.431470,
      0.355451,
      2,
      NULL,
      NULL,
      2.754157,
      1.548330);
commit;
end;
/


