set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9409102';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-11-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '032',
      '13422213',
      28.022611,
      NULL,
      '3400214',
      109,
      6,
      3,
      0,
      '243210',
      2.227527,
      ' 3-12-2001',
      7,
      24,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0.598596,
      0.811650,
      NULL,
      0.940331,
      NULL,
      0.041530,
      NULL,
      NULL,
      1,
      1.618702,
      6.341554,
      NULL,
      1.241907,
      1,
      0,
      2.192304,
      NULL,
      1.554819,
      2.265362,
      1,
      3,
      3.606916,
      1.780346,
      1.495460,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1.449096,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.160817,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.037969,
      1.131424,
      0,
      1.257044,
      NULL,
      NULL,
      0.575031,
      1,
      1.474590,
      1.861430,
      0,
      0,
      0.912298,
      0,
      1.570091,
      1.508034,
      1.754156,
      1.380266,
      1,
      NULL,
      1,
      0,
      0.929006,
      0.692101,
      0.855080,
      1.092949,
      NULL,
      1,
      2,
      1.497257,
      0.236546,
      2.514752,
      1,
      0.123724,
      1.233804,
      1,
      1,
      3,
      0,
      3.537285,
      NULL,
      0.676514,
      NULL,
      1,
      2,
      NULL,
      NULL,
      1.627126,
      2.617883,
      1,
      1.634601,
      5.629285,
      1.906026,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.441456,
      1,
      1,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0.767783,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.685090,
      1.249878,
      NULL,
      NULL,
      NULL,
      2.805610,
      0,
      NULL,
      5.200757,
      NULL,
      1,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      4.962684,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.611828,
      0,
      1.236009,
      3,
      2,
      1.424634,
      1,
      NULL,
      1,
      2,
      NULL,
      0.916072,
      1,
      0.246664,
      0,
      0,
      1,
      1,
      1,
      0.866190,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.116434,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      5.842203,
      '42010',
      '24033',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      NULL,
      '',
      NULL,
      NULL,
      1.960326,
      1.992199,
      0,
      NULL,
      1.021870,
      1.367150,
      3,
      NULL);
commit;
end;
/


