set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9409102';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-10-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '302',
      '20231200',
      16.609964,
      18,
      '4140344',
      92.910754,
      0,
      2.385960,
      2,
      NULL,
      1,
      ' 6- 6-2002',
      38,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.098765,
      0.084128,
      0,
      0.885018,
      0.593289,
      0,
      1.513702,
      NULL,
      0,
      NULL,
      NULL,
      1.804866,
      2.825700,
      1,
      0,
      1.714270,
      3,
      2.319837,
      5.653166,
      0,
      1.433838,
      4.788102,
      3,
      1.437728,
      NULL,
      NULL,
      1.985218,
      NULL,
      NULL,
      2.265230,
      1.836790,
      0,
      2.581364,
      1,
      0.270605,
      NULL,
      0,
      NULL,
      3,
      1,
      2,
      0,
      3.716972,
      0,
      2,
      NULL,
      1,
      0,
      1,
      5.953719,
      0,
      4.729801,
      0,
      1,
      0.817726,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.318534,
      1,
      0.106021,
      1,
      NULL,
      0.391317,
      0,
      1,
      1,
      0.273902,
      1,
      1.355864,
      0.723445,
      0.505246,
      0,
      1,
      0,
      1.188192,
      0.614281,
      NULL,
      0,
      0,
      1,
      4,
      1,
      1.771211,
      NULL,
      0,
      5,
      1,
      NULL,
      0,
      0,
      1.975504,
      4.986694,
      0,
      1.013454,
      5,
      2,
      2.556068,
      3.841642,
      NULL,
      0.648308,
      0.424755,
      2,
      2,
      0,
      4,
      NULL,
      0.594074,
      0,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.875734,
      0.500205,
      0,
      2,
      1,
      5.829871,
      1,
      0.796506,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.805189,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0,
      NULL,
      NULL,
      NULL,
      2,
      0.449462,
      0.946028,
      NULL,
      NULL,
      NULL,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      3,
      3.347340,
      NULL,
      NULL,
      1.109040,
      3.878398,
      1,
      3.216557,
      0,
      1.085303,
      1,
      0.523587,
      1.520583,
      1.356666,
      0.212462,
      1.213747,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.183005,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '00221',
      '23113',
      '',
      NULL,
      '',
      '',
      NULL,
      0,
      NULL,
      '',
      '',
      2.955967,
      4,
      1,
      1.685759,
      NULL,
      2,
      3,
      3,
      3.112278);
commit;
end;
/


