set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9409102';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-4-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '214',
      '32413211',
      NULL,
      18.345179,
      '4144243',
      3,
      2,
      2.680185,
      2,
      '013314',
      NULL,
      ' 2-24-1992',
      12,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      2.635111,
      0.101057,
      1,
      0,
      NULL,
      1.803995,
      0.605390,
      8,
      6,
      4.468005,
      2,
      1.220750,
      4,
      1,
      1,
      4,
      5.748959,
      0,
      4.237450,
      4,
      1.401154,
      0.917789,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.842155,
      1,
      3.656426,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.174566,
      0.192712,
      4.386072,
      0,
      1.963054,
      0.702384,
      0,
      5.705521,
      NULL,
      0,
      0.875371,
      0.983293,
      NULL,
      1,
      0,
      1,
      1,
      NULL,
      1,
      0.060405,
      1,
      NULL,
      NULL,
      1,
      0,
      0.564735,
      1.422221,
      NULL,
      0.979041,
      1.558374,
      1.506951,
      0,
      4.824431,
      0,
      4.559679,
      NULL,
      NULL,
      4,
      1.700908,
      1.630036,
      1,
      0.546313,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1.011948,
      1,
      0,
      5.768364,
      NULL,
      1.047218,
      NULL,
      1.279462,
      1.211886,
      1,
      2,
      NULL,
      1,
      3,
      0,
      1.953607,
      3.334635,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.079048,
      NULL,
      1.105718,
      3,
      1.772562,
      2.946897,
      1.129074,
      1,
      3,
      0.141977,
      0,
      4,
      0.739418,
      3,
      1.880692,
      0,
      1,
      4.117790,
      NULL,
      0.655826,
      NULL,
      2.775389,
      NULL,
      1.846557,
      1.084842,
      NULL,
      NULL,
      0,
      0.781296,
      0.352761,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      3,
      3,
      0,
      2,
      0,
      3.252292,
      2.146159,
      1,
      1,
      0.375760,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      '24041',
      '04331',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      '43232',
      '',
      '',
      1.703063,
      2,
      1.568760,
      1.015859,
      NULL,
      1.023345,
      2,
      3,
      5.019599);
commit;
end;
/


