set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9409102';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-10-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '112',
      '23134320',
      31.254043,
      36.328824,
      NULL,
      95.974228,
      NULL,
      3,
      1,
      '011344',
      4,
      NULL,
      29.401710,
      19.301828,
      1,
      NULL,
      NULL,
      3,
      0,
      0,
      0,
      1.335712,
      0.944144,
      0,
      1,
      1.687317,
      NULL,
      1.179343,
      NULL,
      4.489292,
      2,
      5,
      4,
      NULL,
      NULL,
      0.587255,
      0.427595,
      1,
      0.649730,
      NULL,
      4,
      3,
      2,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1.859376,
      1.928669,
      1.425236,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      2.084766,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0.529385,
      0,
      1.845817,
      NULL,
      4.364768,
      0.976977,
      1.929274,
      3,
      0.804141,
      0,
      0,
      0,
      NULL,
      NULL,
      0.585730,
      1.742989,
      0.109026,
      1.332859,
      NULL,
      1,
      0,
      0,
      3,
      1,
      NULL,
      NULL,
      0.265180,
      1.750374,
      3,
      0.337737,
      NULL,
      5,
      1.541640,
      6.639653,
      1,
      NULL,
      0,
      1.684643,
      0,
      2,
      0,
      5,
      0,
      0,
      1,
      3.957891,
      0.621089,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.209813,
      1,
      1,
      1,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.120686,
      NULL,
      0,
      2.926657,
      1.261241,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      0.387071,
      NULL,
      NULL,
      NULL,
      5.858528,
      1,
      1.078869,
      0.222716,
      3,
      0,
      1.438441,
      NULL,
      NULL,
      NULL,
      0.412722,
      4,
      0.324963,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.939338,
      1.671499,
      0,
      1,
      NULL,
      0,
      1.923619,
      0,
      2,
      3.649497,
      NULL,
      NULL,
      NULL,
      0.562297,
      1.945125,
      NULL,
      0.898276,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.605183,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.257168,
      NULL,
      '13413',
      '',
      1,
      '',
      NULL,
      '',
      3.101812,
      NULL,
      '',
      '',
      0,
      7,
      3.765334,
      0,
      1,
      3.328553,
      2,
      NULL,
      4);
commit;
end;
/


