set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9409102';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-10-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      13.436471,
      '4002324',
      66.500156,
      1,
      0,
      0,
      '413011',
      4,
      ' 9-22-1980',
      30.679374,
      39.064531,
      1.680409,
      NULL,
      0.076173,
      2.807088,
      0.260487,
      0.575836,
      0,
      1,
      1,
      0.381570,
      1,
      1,
      NULL,
      1,
      0.340265,
      5,
      4,
      3,
      4.956868,
      1,
      3.680741,
      2.647313,
      0.835495,
      0.544142,
      4,
      0,
      1.186828,
      0,
      2.596127,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.882019,
      NULL,
      0.795267,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.193746,
      0.652876,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.973199,
      NULL,
      1.874113,
      0.889715,
      5.512343,
      1.093813,
      0,
      NULL,
      NULL,
      1.901706,
      NULL,
      1.346799,
      NULL,
      0,
      NULL,
      0,
      1,
      1,
      1,
      NULL,
      1.530113,
      0,
      0,
      NULL,
      0.216733,
      0,
      1,
      0.646159,
      1,
      0.648110,
      1.494208,
      3,
      NULL,
      0,
      0.286928,
      NULL,
      NULL,
      1.270983,
      5.731282,
      0.383051,
      3.679721,
      3.034753,
      NULL,
      NULL,
      4.466980,
      2,
      9,
      NULL,
      2.403554,
      0.018060,
      1.838865,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.402833,
      1,
      1,
      1,
      0.712776,
      1,
      NULL,
      0.354190,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      5.873747,
      2.233219,
      NULL,
      1.597642,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.814143,
      NULL,
      NULL,
      NULL,
      1.711905,
      NULL,
      2.503414,
      5.472453,
      2,
      2,
      7.437878,
      0,
      NULL,
      NULL,
      3,
      NULL,
      3,
      NULL,
      4,
      5.040530,
      NULL,
      5,
      NULL,
      NULL,
      3.534302,
      1.482378,
      0,
      0,
      1,
      NULL,
      0,
      NULL,
      0.141094,
      0.032001,
      NULL,
      0,
      1,
      1.566901,
      1,
      0,
      1,
      0.942667,
      0.706750,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.642838,
      '00410',
      '31322',
      '',
      1.012157,
      '',
      '',
      '',
      3,
      NULL,
      '',
      '',
      5.823475,
      3,
      1.991137,
      2.251473,
      3.165853,
      1,
      0,
      2,
      NULL);
commit;
end;
/


