set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9409102';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-4-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '34202033',
      86.778710,
      NULL,
      '1110131',
      218,
      0,
      2,
      1,
      '014040',
      0,
      NULL,
      32,
      NULL,
      0,
      NULL,
      0.745025,
      0,
      1,
      1.859190,
      1.610788,
      1,
      0,
      NULL,
      NULL,
      1,
      0.200336,
      1,
      1.305420,
      0,
      NULL,
      NULL,
      4,
      0.558136,
      5,
      2.565886,
      3.357146,
      0.695183,
      2,
      1,
      2.839504,
      0.512407,
      2,
      0.021617,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.309427,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.103798,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.085269,
      0.054720,
      NULL,
      2,
      1.296157,
      0.661883,
      1,
      1.006420,
      1.977821,
      1,
      1.058572,
      0,
      0,
      1,
      0,
      1,
      NULL,
      0.340499,
      NULL,
      1.028304,
      NULL,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      2,
      1.872636,
      1.606405,
      3.315114,
      1.819520,
      NULL,
      1,
      0.204585,
      NULL,
      2,
      2,
      1.776991,
      5.716931,
      3.698907,
      NULL,
      1.747897,
      NULL,
      2,
      0.585509,
      1,
      2.327096,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.767356,
      0,
      1,
      NULL,
      0.095395,
      0.004351,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.217374,
      NULL,
      3.196578,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.949959,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0.796333,
      1.207834,
      3,
      5.999995,
      4.671564,
      0,
      3.535524,
      0.354147,
      NULL,
      NULL,
      NULL,
      2,
      1.962290,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.454556,
      2,
      NULL,
      1.717663,
      NULL,
      NULL,
      1.616104,
      1,
      1.736528,
      NULL,
      2.101892,
      1.147160,
      0,
      NULL,
      0.951251,
      1.570000,
      1,
      1,
      NULL,
      1.030512,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.850303,
      NULL,
      '31311',
      '',
      1,
      '',
      '',
      '',
      3.990753,
      '00401',
      '',
      '',
      4,
      1,
      1.405036,
      4.046542,
      0.450583,
      0,
      2,
      1,
      2.481794);
commit;
end;
/


