set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9018848';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-9-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '4',
      NULL,
      NULL,
      '1414123',
      50,
      NULL,
      NULL,
      NULL,
      '030423',
      2,
      '11-19-1989',
      24,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1.480879,
      0,
      NULL,
      NULL,
      1.090479,
      1,
      1,
      1.464405,
      NULL,
      1,
      1,
      1.170214,
      1.734166,
      1.692615,
      1,
      1.730732,
      1.122149,
      0.014307,
      1.392839,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.522441,
      1.243633,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.426576,
      1,
      0.755138,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.772705,
      NULL,
      0.245929,
      NULL,
      0.078682,
      0.181414,
      0.135692,
      0,
      0.328401,
      0.439032,
      1.504818,
      NULL,
      NULL,
      0,
      NULL,
      1.148294,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.577618,
      1,
      NULL,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1.935218,
      0.975235,
      0,
      NULL,
      0.384912,
      5.712243,
      5.271929,
      0,
      3.430243,
      5.814685,
      2,
      6,
      5,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      7,
      1.588199,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.668648,
      0,
      0,
      1,
      NULL,
      0,
      0.517860,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.890235,
      NULL,
      NULL,
      NULL,
      NULL,
      2.563344,
      NULL,
      0,
      1.072719,
      NULL,
      NULL,
      5,
      3,
      0.062176,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.286923,
      0.975717,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.244659,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      0,
      NULL,
      1,
      1.745500,
      0,
      2,
      1,
      NULL,
      0.714570,
      0.196829,
      0,
      1,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.533724,
      '33443',
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      '',
      2,
      '2441',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


