set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9018848';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-8-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '311',
      '34',
      50,
      26,
      '0403331',
      73,
      NULL,
      2.598995,
      2,
      '201031',
      4,
      ' 2- 1-1989',
      43,
      53.174303,
      0.794040,
      NULL,
      1,
      3,
      0,
      0.000607,
      NULL,
      1.816771,
      0,
      NULL,
      0.594298,
      0.380688,
      3,
      0.892964,
      NULL,
      1.007539,
      0,
      0,
      NULL,
      1,
      2,
      NULL,
      0.623411,
      0,
      4.295029,
      0,
      0.009505,
      0,
      1.467502,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4,
      0,
      1.217302,
      0.317422,
      3,
      0,
      3,
      1.774722,
      2,
      0,
      0,
      1,
      NULL,
      2.775633,
      0,
      1,
      0,
      NULL,
      0.726157,
      0.759583,
      NULL,
      NULL,
      0.928199,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.678271,
      0,
      0.066106,
      0,
      NULL,
      1.852448,
      0,
      0,
      NULL,
      1.199761,
      NULL,
      0,
      1.542526,
      1,
      0,
      0.914819,
      NULL,
      0.663959,
      1,
      NULL,
      NULL,
      NULL,
      0.191086,
      1,
      0.631083,
      0.843598,
      0,
      1.455263,
      0,
      1.819491,
      NULL,
      1,
      0,
      NULL,
      0,
      1.889011,
      NULL,
      7.477179,
      1,
      1.438246,
      3,
      0,
      4,
      1.269351,
      2.433746,
      1,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.157411,
      1,
      1,
      1,
      1,
      1,
      1.352281,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.792051,
      NULL,
      7,
      NULL,
      2.383565,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.366242,
      0.608209,
      1.548921,
      NULL,
      NULL,
      NULL,
      0.671505,
      0,
      NULL,
      1.366848,
      1.298250,
      2,
      0.385730,
      NULL,
      NULL,
      NULL,
      1,
      2.527237,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      2,
      0.700629,
      NULL,
      0.076836,
      NULL,
      1.073312,
      1.394464,
      0,
      0.493515,
      1,
      NULL,
      0,
      0,
      0,
      0.633692,
      0.551603,
      1.103450,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.297062,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      '',
      '',
      1.434682,
      NULL,
      '',
      '',
      0.908875,
      '0011',
      '',
      '',
      3.641630,
      1.727092,
      3.460840,
      NULL,
      1,
      1.929046,
      0.644743,
      NULL,
      0.591319);
commit;
end;
/


