set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9018848';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-8-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '030',
      '34040434',
      53,
      34,
      '2132123',
      77.405744,
      0,
      NULL,
      2,
      '341431',
      2,
      ' 7-20-1977',
      3.016234,
      60.188130,
      1,
      NULL,
      1,
      0.507065,
      3.062266,
      NULL,
      1,
      0,
      2.737770,
      0.242517,
      1,
      1.760596,
      2.436477,
      1,
      0,
      NULL,
      1,
      1.524245,
      NULL,
      0,
      5,
      0.035894,
      NULL,
      0.734708,
      6,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4,
      1,
      0.456823,
      2,
      1.920842,
      0.149274,
      NULL,
      NULL,
      1.532076,
      2,
      1.615080,
      0,
      1.189630,
      NULL,
      NULL,
      0,
      0,
      1,
      0.612810,
      2,
      1.675439,
      0,
      2,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.090590,
      3,
      0.139605,
      1.573472,
      3.064240,
      5,
      1.205264,
      0.988049,
      4,
      3.338554,
      1,
      0.090696,
      1,
      1.005214,
      0.871793,
      0.038264,
      0.336838,
      0.993834,
      NULL,
      0.448281,
      0,
      0.556822,
      0.722283,
      0.513754,
      1.151500,
      0.953339,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1.295508,
      1,
      0.516585,
      1,
      0,
      3,
      0,
      0.768247,
      4.668384,
      NULL,
      0,
      NULL,
      5.537205,
      5,
      1,
      NULL,
      1,
      NULL,
      1.252503,
      2.815490,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.088556,
      1.387256,
      1,
      NULL,
      0,
      3,
      0.466698,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.894611,
      NULL,
      NULL,
      NULL,
      NULL,
      1.876830,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0.816541,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1.539198,
      0,
      0.198936,
      NULL,
      NULL,
      NULL,
      1,
      1.239878,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.955584,
      NULL,
      1.138017,
      1,
      2.956432,
      0.405565,
      0,
      1,
      3.787585,
      1.575414,
      1.733239,
      0,
      0,
      1.111188,
      1.779964,
      0,
      0,
      0,
      0.144371,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '03141',
      '',
      '',
      0,
      '',
      '',
      '',
      0.808415,
      '1023',
      '',
      NULL,
      3.053624,
      3,
      1.078330,
      NULL,
      2,
      3,
      2.841389,
      1.739693,
      1);
commit;
end;
/


