set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9018848';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-2-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '433',
      '12131311',
      14.808331,
      15.775469,
      NULL,
      NULL,
      1,
      3.248048,
      1,
      '433444',
      0,
      ' 3- 6-2002',
      NULL,
      NULL,
      0,
      NULL,
      0.700858,
      0.658777,
      0,
      1.979529,
      0,
      1,
      NULL,
      0.485836,
      1,
      0.924655,
      5.897172,
      1.368012,
      1.583294,
      1.984360,
      1,
      1,
      5,
      0.617179,
      1,
      4,
      0.088922,
      0.855499,
      2,
      1,
      5.768268,
      5.783160,
      2.131316,
      1,
      NULL,
      NULL,
      0.382178,
      NULL,
      NULL,
      4.856966,
      1.009164,
      5.024873,
      2,
      3.074951,
      0,
      NULL,
      NULL,
      2,
      3,
      3.880722,
      NULL,
      1,
      1.933350,
      1,
      0,
      NULL,
      0,
      1.405729,
      0.403486,
      NULL,
      1,
      1.767461,
      1,
      2,
      0.919672,
      1.855033,
      NULL,
      NULL,
      1.146072,
      NULL,
      NULL,
      0.750535,
      1.829064,
      1.244981,
      0,
      0,
      0,
      2,
      NULL,
      1.452542,
      NULL,
      3,
      0,
      0.319590,
      1,
      NULL,
      0,
      1.182526,
      0.831150,
      0,
      NULL,
      0.291234,
      1.296313,
      1,
      0,
      0.654495,
      NULL,
      0.757823,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      0.580960,
      0,
      NULL,
      5.259009,
      5.147477,
      4,
      1.593027,
      9,
      1,
      1,
      0,
      2.702434,
      3,
      1.548004,
      1.418423,
      2.792982,
      1.085607,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0,
      0,
      0.279778,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      7.300235,
      0.794018,
      3,
      1,
      1.660776,
      NULL,
      5.114704,
      0,
      0,
      0,
      NULL,
      1.081743,
      0,
      1,
      4.614908,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4,
      0.322243,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.752310,
      3.551096,
      1,
      1.718061,
      0,
      2.033446,
      1,
      0,
      0.788265,
      3,
      0,
      1,
      1,
      0,
      0,
      0.141420,
      NULL,
      1.160314,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.955119,
      '23003',
      '',
      NULL,
      NULL,
      '',
      NULL,
      '',
      1.951709,
      '0341',
      '',
      '',
      0,
      2,
      5,
      NULL,
      1,
      0,
      2.776347,
      NULL,
      0);
commit;
end;
/


