set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9018848';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-2-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '102',
      '00424001',
      NULL,
      NULL,
      '1124132',
      NULL,
      0,
      1,
      NULL,
      '143410',
      NULL,
      NULL,
      NULL,
      25.165039,
      1.748614,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0,
      0,
      1,
      0.770181,
      1.780935,
      0,
      1,
      0.116209,
      0,
      1,
      0,
      5,
      1,
      NULL,
      7,
      6,
      4,
      0,
      6,
      1,
      1.664787,
      2.551652,
      0,
      0.659549,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      2,
      1.535200,
      1,
      3,
      1.665426,
      0,
      0.525885,
      1.166873,
      1.939491,
      NULL,
      2.854787,
      0,
      NULL,
      0,
      1,
      2,
      0.041095,
      0.316394,
      NULL,
      0,
      0,
      2.228273,
      NULL,
      1,
      1.887873,
      1.032261,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.304782,
      NULL,
      4,
      0,
      NULL,
      0.887385,
      4.475595,
      1,
      1.185761,
      3,
      3.927705,
      NULL,
      1.969449,
      NULL,
      0,
      1.177369,
      1,
      1.621532,
      1,
      NULL,
      1.405667,
      0,
      0,
      NULL,
      1.869103,
      0.235937,
      1,
      NULL,
      0.478920,
      0.917154,
      1.696362,
      NULL,
      NULL,
      0,
      0.370710,
      NULL,
      1.363419,
      7.207194,
      NULL,
      4,
      0.038492,
      NULL,
      NULL,
      0,
      NULL,
      0.863239,
      10,
      3,
      NULL,
      0.237470,
      1.275853,
      9.492821,
      3.862241,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.899463,
      2,
      1,
      1.223062,
      0.260319,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      0.919105,
      NULL,
      NULL,
      NULL,
      4,
      0,
      0,
      0,
      0,
      0,
      1.251347,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.876689,
      0.148023,
      2.682932,
      0.462059,
      NULL,
      1.163727,
      0.967973,
      1,
      0,
      1,
      NULL,
      1,
      0,
      1.731686,
      0.142125,
      0.229909,
      1.308525,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4,
      '21103',
      NULL,
      '',
      0.579493,
      '',
      '',
      NULL,
      2.685031,
      '3030',
      '',
      '',
      2,
      6.104718,
      1.524340,
      3,
      NULL,
      1.806757,
      0.811351,
      3.033700,
      2);
commit;
end;
/


