set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9018848';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-8-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '403',
      '44041340',
      25.240909,
      NULL,
      '3222012',
      65.425506,
      5,
      0.756473,
      2,
      '203130',
      3,
      ' 7-29-1990',
      15.370856,
      28,
      0.483171,
      NULL,
      NULL,
      3.738393,
      0,
      0.126912,
      NULL,
      1,
      1.529774,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0.605857,
      5.315856,
      1,
      4,
      5,
      1,
      0,
      5.709054,
      NULL,
      3,
      7.414984,
      1,
      2.879638,
      5.402168,
      NULL,
      1,
      NULL,
      NULL,
      0.504621,
      NULL,
      NULL,
      0,
      0.897659,
      1,
      2.258952,
      0.824940,
      1.328712,
      2,
      0.829389,
      3.572341,
      1,
      3.432002,
      0.823946,
      0,
      3.367316,
      1,
      NULL,
      NULL,
      NULL,
      0.718283,
      0.376675,
      0.437012,
      0.915994,
      4.257162,
      1,
      0,
      1.463908,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.335494,
      NULL,
      1,
      NULL,
      NULL,
      4,
      1,
      0,
      NULL,
      5,
      NULL,
      0.541114,
      0,
      1.470528,
      1,
      NULL,
      0.001363,
      1,
      NULL,
      0.131292,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      1.667207,
      3,
      NULL,
      NULL,
      2.891633,
      1.812744,
      NULL,
      NULL,
      NULL,
      1,
      1,
      2.636598,
      0,
      4.080182,
      0,
      5.519492,
      3.582404,
      7,
      NULL,
      NULL,
      3.125532,
      1.809151,
      NULL,
      0.676618,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      2,
      1.261688,
      1,
      1.857169,
      1.373411,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2.305138,
      0,
      NULL,
      2.445000,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.297856,
      NULL,
      0,
      6.781056,
      1,
      0,
      1.539229,
      NULL,
      NULL,
      NULL,
      0,
      5,
      0.828565,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2.994670,
      0,
      0,
      3,
      3,
      1,
      NULL,
      1,
      2,
      NULL,
      0.877924,
      1,
      1,
      0.690300,
      0,
      1.375924,
      0.004495,
      0.943727,
      1.991359,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.700289,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      '23104',
      '34140',
      NULL,
      NULL,
      '',
      '',
      '',
      2,
      '0114',
      '',
      '',
      2.929890,
      2,
      1.240587,
      0.853267,
      0,
      0,
      3.913221,
      1.727959,
      3);
commit;
end;
/


