set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9018848';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-2-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '130',
      '12232010',
      72,
      9.901707,
      NULL,
      92.446084,
      3,
      3.582077,
      2,
      NULL,
      1,
      ' 9- 5-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      0.611403,
      3,
      NULL,
      1,
      NULL,
      1.264317,
      1,
      1.666750,
      3,
      NULL,
      0,
      7,
      NULL,
      2.593470,
      2,
      4,
      0,
      4,
      1,
      1,
      1.683969,
      3.122096,
      1.449427,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      5.188632,
      1,
      3.903155,
      0,
      1,
      3.205572,
      0,
      1.900312,
      0,
      0,
      1,
      0.357446,
      NULL,
      1,
      3,
      NULL,
      0.014068,
      0,
      1,
      1.854119,
      0,
      NULL,
      0,
      1,
      1.014845,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.341368,
      1,
      5.306206,
      1,
      3,
      4.170301,
      4,
      0,
      0.303632,
      4,
      0.671151,
      0,
      0.307884,
      4,
      0.033513,
      NULL,
      0.203435,
      1.281882,
      1.692888,
      NULL,
      0.856039,
      NULL,
      0.990208,
      0.769082,
      1.900118,
      1.937451,
      0.575289,
      0.900749,
      NULL,
      0.848509,
      0.766926,
      NULL,
      NULL,
      1.847221,
      3.568658,
      1.508063,
      1,
      NULL,
      1.567513,
      NULL,
      3,
      NULL,
      3.972031,
      1.239761,
      NULL,
      5,
      7,
      1,
      0,
      0.531571,
      NULL,
      5.067216,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.036529,
      6.326876,
      0,
      0,
      1.753770,
      1,
      4,
      1.159736,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      3.464101,
      0.460269,
      4,
      1,
      1.316895,
      3.288114,
      1,
      4,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0.342013,
      7.619003,
      4,
      1,
      0,
      1.302063,
      NULL,
      NULL,
      NULL,
      1,
      8,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.339747,
      0.806303,
      1,
      1,
      3,
      0,
      0,
      1,
      1,
      1.203140,
      0,
      1,
      1.829893,
      0.262983,
      1,
      1.757113,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '33002',
      '',
      NULL,
      0.456633,
      '',
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      2,
      1.498255,
      NULL,
      2.843239,
      3,
      3,
      0,
      1.233665,
      NULL);
commit;
end;
/


