set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9018848';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-8-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1104',
      NULL,
      11,
      57,
      '1034431',
      10.846928,
      2,
      3.335296,
      1,
      NULL,
      1,
      ' 5-20-1999',
      22.365074,
      59.023893,
      0.831177,
      NULL,
      0,
      3,
      NULL,
      1,
      0,
      0,
      1,
      1.157597,
      1.371413,
      NULL,
      6,
      0.898325,
      0.154477,
      1.242430,
      0.050009,
      0,
      NULL,
      0,
      NULL,
      2.268262,
      0.168627,
      0,
      0.053729,
      0,
      1,
      1.510643,
      NULL,
      1.533361,
      NULL,
      NULL,
      1.072529,
      NULL,
      NULL,
      0.175746,
      1.719579,
      1.884642,
      0.562858,
      1,
      1,
      3,
      1.487032,
      1.285683,
      1.164791,
      NULL,
      1,
      0,
      0,
      NULL,
      2.246960,
      0.443466,
      0.229245,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      1.236839,
      0.213929,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1.316803,
      5,
      1,
      1,
      4.161329,
      NULL,
      0,
      1,
      0,
      3.420694,
      0,
      1,
      5.455559,
      NULL,
      1,
      NULL,
      0.174006,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      0.076949,
      NULL,
      1.635611,
      1.580726,
      4.950648,
      0,
      NULL,
      3.759764,
      0,
      1.569271,
      NULL,
      NULL,
      0,
      NULL,
      2.140382,
      1.523004,
      0.076558,
      6.476111,
      0,
      5.062070,
      5,
      NULL,
      0,
      2,
      2,
      1.602885,
      1.615120,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.796449,
      1.946845,
      NULL,
      1,
      1.946947,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.420488,
      NULL,
      0.741167,
      NULL,
      NULL,
      NULL,
      NULL,
      0.827153,
      2.842230,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3.163403,
      0.174439,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.310519,
      NULL,
      2,
      1.105586,
      2.837884,
      3,
      0,
      1,
      0,
      2.250468,
      0.387146,
      0,
      1.394717,
      0,
      NULL,
      0,
      1.237218,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      '',
      '',
      0,
      '',
      '',
      NULL,
      1,
      '0343',
      '',
      '',
      0,
      1,
      NULL,
      2,
      3,
      2.796097,
      2.616879,
      3.009552,
      2.878096);
commit;
end;
/


