set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9018848';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-2-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '14221332',
      NULL,
      66.676944,
      NULL,
      90,
      NULL,
      1.843292,
      1,
      NULL,
      3,
      ' 7- 4-1997',
      50.848634,
      45.815320,
      1.009260,
      NULL,
      1,
      0.003440,
      0,
      1.869668,
      1.609329,
      1,
      2,
      1,
      1.043368,
      NULL,
      4.545535,
      0.893781,
      0,
      NULL,
      1.242623,
      NULL,
      2,
      0.648936,
      0.425612,
      0.424607,
      NULL,
      1,
      NULL,
      0,
      0,
      1.033455,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.795648,
      0,
      0.353761,
      2.431621,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      1.521927,
      NULL,
      NULL,
      NULL,
      1.995150,
      1,
      0.437155,
      NULL,
      0,
      0,
      0.289707,
      0.878843,
      NULL,
      0.212467,
      NULL,
      1.303117,
      NULL,
      0,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1.173797,
      0,
      1.250039,
      1.827275,
      0,
      0.317748,
      0,
      0,
      0.073592,
      0,
      1,
      0.074641,
      0.238363,
      1.132524,
      NULL,
      1,
      8.578009,
      NULL,
      5,
      2,
      1.040624,
      NULL,
      3.723318,
      0,
      2,
      1.807388,
      NULL,
      0,
      NULL,
      NULL,
      9.771834,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.314827,
      0.794894,
      1,
      0,
      NULL,
      1.374268,
      NULL,
      1.343812,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.663249,
      NULL,
      NULL,
      NULL,
      NULL,
      0.467924,
      2.898208,
      3.698042,
      0.127853,
      1.007700,
      0,
      8,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.351902,
      0.635069,
      5.329496,
      3,
      1,
      0,
      0.462182,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.327438,
      0.226806,
      0.409504,
      0.531274,
      0.896454,
      0,
      1.900377,
      0,
      1.595206,
      0.505178,
      NULL,
      0.491509,
      0.286907,
      1,
      0.641873,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.755989,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      '40122',
      '',
      NULL,
      0.564888,
      '',
      '',
      '',
      2,
      '0412',
      NULL,
      '',
      3,
      4.312463,
      NULL,
      3,
      NULL,
      0,
      NULL,
      NULL,
      3);
commit;
end;
/


