set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9018848';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-8-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0124',
      '11132001',
      NULL,
      NULL,
      NULL,
      51.382437,
      NULL,
      0.725731,
      1,
      '402400',
      1.488880,
      ' 2-15-1992',
      8,
      59.133308,
      1.757100,
      NULL,
      1,
      0,
      0,
      1.405985,
      NULL,
      0.037803,
      2,
      0.325727,
      0.335851,
      0.672362,
      NULL,
      1,
      1,
      NULL,
      0,
      0,
      2.236948,
      1,
      3.865030,
      1.739963,
      1.902596,
      NULL,
      0,
      1,
      0.027286,
      1.102668,
      NULL,
      1.052911,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.919960,
      3,
      0,
      0.147907,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.557641,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3,
      0,
      1.626821,
      4.535340,
      2,
      1,
      0.569513,
      1,
      NULL,
      NULL,
      0,
      6,
      1.892650,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.853981,
      0,
      1.895790,
      1.994928,
      1,
      0,
      NULL,
      1,
      1.229373,
      NULL,
      1,
      0.081478,
      1.138481,
      0,
      1.398754,
      1.495630,
      1,
      9.698432,
      5,
      7,
      0.687273,
      0,
      NULL,
      1.390630,
      0,
      5.669470,
      0.069403,
      4,
      NULL,
      1,
      0.511420,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.921959,
      5.373550,
      0,
      NULL,
      1,
      0.101234,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.523388,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.850586,
      1.551205,
      NULL,
      NULL,
      NULL,
      0,
      0,
      5,
      NULL,
      0.448702,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.824115,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      1.377730,
      0.980289,
      3.304838,
      0.738702,
      NULL,
      0,
      0.092161,
      1,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      1,
      1.608113,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.651853,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.195039,
      '00103',
      '',
      '',
      1,
      '',
      '',
      '',
      4,
      '4112',
      '1313',
      '',
      4.614838,
      NULL,
      0,
      5.307489,
      3.738851,
      3,
      2,
      0,
      NULL);
commit;
end;
/


