set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9018848';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-3-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2133',
      '21122021',
      1,
      56.084235,
      '0003222',
      NULL,
      NULL,
      2.593135,
      1,
      '124021',
      NULL,
      ' 8- 0-1977',
      41.796035,
      NULL,
      1,
      NULL,
      1,
      1.276789,
      NULL,
      1.026087,
      1.837278,
      1.768131,
      2.527536,
      NULL,
      0,
      1.927620,
      2.868973,
      0,
      1.452901,
      1,
      1.069262,
      1,
      1.633885,
      1,
      1,
      1.278435,
      0.273026,
      0.700159,
      2.868041,
      NULL,
      2.092945,
      1.747266,
      1.210271,
      1.747208,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      2,
      1.841547,
      3.880729,
      NULL,
      0.587897,
      NULL,
      0.204143,
      0.950443,
      0.714124,
      3.002323,
      0.955500,
      NULL,
      1,
      3,
      0.465208,
      NULL,
      NULL,
      NULL,
      1.808771,
      1.660015,
      1,
      5,
      NULL,
      1,
      1.519172,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.205240,
      1.842905,
      NULL,
      5,
      1.270328,
      4.041726,
      1.337077,
      0,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      NULL,
      1.518314,
      NULL,
      NULL,
      NULL,
      0.803677,
      1,
      1.048277,
      1,
      1,
      0.950275,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      0.806049,
      9,
      0.826304,
      3.317785,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1.630632,
      1.345707,
      0.701761,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.568375,
      0,
      NULL,
      1,
      1,
      0.606124,
      0.370044,
      1.377493,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      2.884294,
      1,
      NULL,
      NULL,
      NULL,
      1.931503,
      0.711012,
      3.284751,
      3,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.688983,
      2.859105,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.582913,
      3.186024,
      0,
      1.690762,
      1.434916,
      0.471719,
      1.714041,
      NULL,
      1.789950,
      NULL,
      NULL,
      1.394743,
      1,
      0.676736,
      0.754699,
      1.536522,
      1.734063,
      0.767260,
      0.793950,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.668911,
      '03012',
      '',
      '',
      0.650344,
      '',
      '',
      '',
      3,
      '3211',
      '3200',
      '',
      1.485387,
      1.181689,
      1.963635,
      NULL,
      2,
      NULL,
      1,
      1.750355,
      NULL);
commit;
end;
/


