set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9887642';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-10-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0410',
      '23231031',
      78,
      48.694997,
      '4102330',
      11.102342,
      1,
      0.999970,
      NULL,
      NULL,
      NULL,
      NULL,
      56.705354,
      59.513632,
      1,
      NULL,
      1.923810,
      NULL,
      0,
      NULL,
      0.940883,
      1.346937,
      0.327973,
      NULL,
      1.541372,
      0,
      0,
      NULL,
      5,
      NULL,
      NULL,
      3.587052,
      4.444739,
      1,
      1.302966,
      4,
      0,
      0,
      3.076800,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      6.713011,
      3.919819,
      NULL,
      NULL,
      3,
      3,
      1.094985,
      0.172812,
      3.038039,
      3,
      2,
      NULL,
      0,
      2.226513,
      1,
      1,
      0,
      0,
      0.036978,
      NULL,
      1,
      2,
      NULL,
      NULL,
      0,
      2,
      0,
      NULL,
      NULL,
      0.847269,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.072695,
      8.870529,
      1.838764,
      NULL,
      0.219656,
      5.721993,
      NULL,
      NULL,
      1,
      1,
      3.964356,
      NULL,
      1,
      0.833616,
      1.800601,
      0,
      NULL,
      1,
      1,
      1.163184,
      0,
      NULL,
      0,
      1.360090,
      1.384693,
      1.128265,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1.326652,
      1,
      1,
      2,
      2,
      7,
      0.362134,
      0,
      0,
      7,
      NULL,
      6.333375,
      0.205398,
      2.378139,
      NULL,
      1.126566,
      3.761688,
      1.525272,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.552469,
      3,
      0,
      NULL,
      1,
      1,
      4.865333,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0.233480,
      0,
      8,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.071285,
      1.454890,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1.441369,
      1,
      3,
      NULL,
      0.511190,
      3.305581,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1.204652,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.172008,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      '22311',
      '',
      '',
      0.323180,
      NULL,
      '',
      '',
      2.135159,
      '2430',
      NULL,
      '',
      2,
      1,
      3,
      NULL,
      2,
      NULL,
      2.765713,
      4.371760,
      NULL);
commit;
end;
/


