set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9887642';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-7-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '43343123',
      24,
      21,
      '1424414',
      47,
      4,
      0.582267,
      1,
      '043322',
      1.467739,
      ' 7-21-2002',
      NULL,
      65,
      1.217522,
      NULL,
      2.124755,
      0.884049,
      NULL,
      1,
      NULL,
      NULL,
      1.412785,
      1.520458,
      3.860674,
      0.295736,
      0.781800,
      1,
      0.899118,
      NULL,
      1,
      0,
      0,
      1,
      1,
      NULL,
      1.997895,
      0.793108,
      1.154857,
      0,
      1,
      1.580891,
      1.730849,
      0,
      NULL,
      NULL,
      0.181973,
      NULL,
      NULL,
      NULL,
      0,
      1.200452,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.483075,
      0.977024,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.350860,
      0,
      0.249324,
      NULL,
      0,
      1,
      0.120710,
      1,
      1,
      1.933982,
      1.782509,
      0,
      1.232478,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.114481,
      0,
      NULL,
      1.393902,
      1.327651,
      NULL,
      NULL,
      NULL,
      0.327856,
      1.732255,
      1,
      0,
      1,
      NULL,
      0.647993,
      1,
      0.517491,
      NULL,
      NULL,
      4.953195,
      7.052608,
      3.466009,
      1,
      NULL,
      6,
      0.505848,
      0.291814,
      5.831560,
      0.814458,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.528800,
      NULL,
      0,
      1,
      1,
      0.262920,
      0.207944,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.696292,
      NULL,
      NULL,
      1.954092,
      0.370360,
      NULL,
      2.137414,
      1,
      1.098897,
      1,
      NULL,
      2,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0.197803,
      NULL,
      5.834953,
      0.462403,
      4,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      1.827392,
      0.835190,
      0,
      1,
      1.530538,
      0.816948,
      1.310173,
      1.328269,
      1,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1.182383,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.581716,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.523276,
      NULL,
      '',
      '',
      0,
      NULL,
      '',
      '',
      NULL,
      '0004',
      '',
      NULL,
      0.712485,
      1,
      NULL,
      NULL,
      3.433201,
      2,
      3,
      3.698465,
      4);
commit;
end;
/


