set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9887642';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-1-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2331',
      '30104034',
      NULL,
      22,
      '0332100',
      16,
      NULL,
      1,
      0,
      NULL,
      5,
      ' 2-20-1977',
      48,
      7,
      NULL,
      NULL,
      3,
      3.395275,
      NULL,
      1.327702,
      1,
      3.156489,
      1,
      0.023481,
      3,
      1,
      NULL,
      1.766118,
      NULL,
      1,
      0.547412,
      1,
      2,
      1.747396,
      0.855808,
      1,
      0.436078,
      0.382728,
      0,
      1,
      1.528918,
      NULL,
      0.682471,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.881334,
      1.855856,
      0,
      1.120882,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.085919,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.462816,
      NULL,
      0,
      0.904287,
      0,
      0.815759,
      0,
      1.294471,
      0.104119,
      1,
      0,
      NULL,
      1,
      NULL,
      0.898740,
      1,
      0.544200,
      0.844944,
      NULL,
      1.242820,
      1.070341,
      1.742914,
      NULL,
      0,
      1,
      NULL,
      0,
      0.153043,
      NULL,
      1,
      NULL,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0.918788,
      0,
      5,
      1,
      2.053482,
      NULL,
      3,
      0,
      3.563424,
      0.870414,
      1,
      NULL,
      NULL,
      9.468305,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.040084,
      0,
      1,
      1.794486,
      1.831946,
      0.622936,
      1.907062,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.098436,
      0,
      1.609717,
      0.947046,
      1.822676,
      2,
      2.742870,
      1,
      4,
      2.357886,
      1.146665,
      NULL,
      NULL,
      NULL,
      2,
      0.835863,
      4,
      0.690448,
      1.735522,
      1,
      4.150468,
      1.016389,
      NULL,
      NULL,
      NULL,
      0.953718,
      0.633401,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.735603,
      1.869673,
      3.175910,
      NULL,
      1.209763,
      NULL,
      0.727717,
      1.605286,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0.831874,
      0.495111,
      0,
      0.731548,
      1.748309,
      0.827624,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.738528,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.532718,
      NULL,
      '',
      '',
      0,
      '',
      '',
      NULL,
      0,
      '3323',
      '',
      '',
      NULL,
      NULL,
      1,
      5,
      NULL,
      3.411081,
      NULL,
      2.209663,
      2);
commit;
end;
/


