set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9038203';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-9-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '1',
      NULL,
      NULL,
      NULL,
      54,
      1,
      1.281856,
      3,
      '134301',
      1,
      ' 4-16-1989',
      NULL,
      NULL,
      0.723798,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      3.043475,
      1.026587,
      2.472788,
      1.879320,
      NULL,
      NULL,
      NULL,
      0.134511,
      1.996668,
      0,
      1,
      1.621654,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0.077076,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.378573,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.244617,
      NULL,
      1.023846,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      2.641813,
      0,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1,
      1.237664,
      0,
      0.441814,
      NULL,
      1.927884,
      1.298220,
      1,
      0.372792,
      NULL,
      0,
      NULL,
      0.821903,
      5,
      0.006430,
      NULL,
      NULL,
      0,
      2,
      1,
      NULL,
      3,
      1,
      1,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      7,
      6,
      9.370420,
      6,
      0.864855,
      4.831085,
      3.046597,
      1.621044,
      NULL,
      NULL,
      0.593142,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.070585,
      1,
      NULL,
      0.073387,
      NULL,
      0.797662,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.367853,
      NULL,
      NULL,
      NULL,
      NULL,
      1.025237,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0.638573,
      3,
      0.696698,
      0.592466,
      0,
      0.873779,
      NULL,
      4.759722,
      NULL,
      0.282770,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.155973,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.135220,
      NULL,
      NULL,
      1,
      2,
      NULL,
      1.213520,
      NULL,
      1.692330,
      0.608029,
      0,
      0.288854,
      0.794771,
      0.363123,
      0.335700,
      0.573464,
      NULL,
      1.557472,
      0,
      1.414731,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      '40243',
      NULL,
      '',
      1,
      '',
      '',
      '',
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


