set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9038203';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-9-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '110',
      NULL,
      13,
      14,
      '2021230',
      NULL,
      5,
      NULL,
      1,
      NULL,
      4,
      NULL,
      29,
      54.204193,
      0.102242,
      NULL,
      2,
      0,
      0.772361,
      NULL,
      0,
      1.288799,
      0,
      3,
      0,
      0,
      3,
      0,
      0.876528,
      0.282626,
      1.713826,
      4,
      2,
      NULL,
      1.838780,
      1,
      0.138222,
      3.171466,
      2.264585,
      0,
      5.758646,
      3,
      0.306915,
      NULL,
      NULL,
      NULL,
      0.594862,
      NULL,
      NULL,
      NULL,
      3,
      2.963262,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.352242,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.604564,
      1,
      1,
      2,
      4.151127,
      1.210729,
      2.655344,
      1.718114,
      4,
      NULL,
      0.123358,
      2,
      0,
      0.056098,
      1.898967,
      1.031526,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.254549,
      0.159034,
      0,
      1.023151,
      1.036683,
      1,
      0,
      0,
      6,
      2,
      1.039630,
      5,
      3,
      9,
      7,
      7,
      8,
      4,
      9.930264,
      6,
      0.720050,
      0.565482,
      NULL,
      NULL,
      7,
      2,
      NULL,
      1.673392,
      1,
      1.133888,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.173368,
      NULL,
      0,
      1,
      1.881118,
      0.382601,
      2.472501,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.744956,
      NULL,
      NULL,
      NULL,
      NULL,
      1.969176,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.038452,
      0.340470,
      0.156407,
      2.470159,
      NULL,
      2.330790,
      7,
      1,
      0.503870,
      2.822265,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.333211,
      1.710627,
      0.045892,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.433125,
      1,
      0.657827,
      0,
      NULL,
      2.045764,
      1.263790,
      0,
      0.122443,
      1,
      1,
      1.798233,
      1.721537,
      0.076044,
      0.289145,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      '41103',
      '',
      '',
      1.245471,
      NULL,
      '',
      NULL,
      1.565187,
      '',
      '',
      '',
      4.041108,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


