set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9038203';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-8-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '041',
      NULL,
      32,
      35.969107,
      '1430042',
      43,
      1,
      3.872757,
      0,
      '121203',
      NULL,
      ' 0-19-1985',
      12.217514,
      33,
      1,
      NULL,
      3,
      NULL,
      1,
      NULL,
      1,
      2.906773,
      1,
      3.762040,
      1.996959,
      1.222350,
      5,
      NULL,
      1.545464,
      0.991951,
      1.171107,
      0,
      5.936967,
      1,
      0,
      0,
      0,
      1,
      NULL,
      0,
      2.958875,
      3.646652,
      0.265398,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.402363,
      1.934222,
      NULL,
      1.557658,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.851408,
      1,
      0.540771,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.057010,
      1,
      1.047833,
      1.145072,
      0,
      NULL,
      1,
      1.374940,
      0.327081,
      0.193750,
      1.138769,
      1.554035,
      3.671517,
      1.146698,
      NULL,
      1.640570,
      NULL,
      1,
      NULL,
      1.809939,
      7.933690,
      NULL,
      0,
      4.534186,
      1,
      NULL,
      1,
      2.393580,
      1.827946,
      0.023333,
      4,
      3.105783,
      0.920296,
      1,
      5.905478,
      7,
      8,
      9,
      NULL,
      NULL,
      5,
      7,
      NULL,
      NULL,
      4.869957,
      NULL,
      3,
      2.750822,
      0.009194,
      0.222254,
      1.525552,
      1.069385,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.048000,
      1,
      0,
      0.028901,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.374596,
      0.024671,
      NULL,
      NULL,
      NULL,
      5.768724,
      0,
      6,
      3.848137,
      1.288454,
      NULL,
      1.148163,
      NULL,
      NULL,
      NULL,
      1.684089,
      0.345549,
      0.551233,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.558613,
      2.120531,
      1.822481,
      1.244702,
      3,
      NULL,
      NULL,
      1.206819,
      NULL,
      3.718671,
      NULL,
      0,
      0.000111,
      NULL,
      1,
      1.101909,
      0,
      1.306807,
      0.190111,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.021781,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      '14100',
      '',
      '',
      1,
      '',
      '',
      '',
      1.089571,
      NULL,
      '',
      '',
      1,
      1,
      NULL,
      2.778194,
      1,
      NULL,
      0.581508,
      NULL,
      1.708252);
commit;
end;
/


