set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9038203';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-2-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '201',
      '12130330',
      NULL,
      13.582640,
      '3333401',
      26,
      4,
      3.191371,
      3,
      '024012',
      2,
      NULL,
      NULL,
      NULL,
      1.894980,
      NULL,
      3,
      1,
      2.551197,
      0,
      1,
      1,
      0.912674,
      0.105009,
      0.036920,
      NULL,
      6,
      1,
      2,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1.978490,
      0,
      NULL,
      1.223935,
      3,
      1,
      3.844509,
      2.993544,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.535047,
      1.161133,
      NULL,
      1.574685,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.485815,
      1,
      1.159678,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.140275,
      0,
      NULL,
      1.088335,
      3,
      0,
      NULL,
      1,
      NULL,
      0,
      0.209242,
      NULL,
      0.396915,
      5,
      0.891901,
      0,
      1.278361,
      NULL,
      1,
      NULL,
      0.692458,
      2,
      5.595791,
      1,
      5.044972,
      1,
      5.795212,
      1.614866,
      3,
      1.137113,
      0,
      3,
      2.951319,
      1.107031,
      1.964528,
      4.141533,
      2,
      NULL,
      NULL,
      6,
      1,
      NULL,
      NULL,
      0.951212,
      4.384240,
      NULL,
      0,
      2,
      NULL,
      0,
      1,
      5,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1.304157,
      0.022244,
      0.662614,
      0.922873,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.537742,
      2,
      3.230345,
      1,
      0.336757,
      4.174063,
      0,
      NULL,
      5,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.923452,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      0.281054,
      1,
      2,
      0.994615,
      1,
      0,
      3,
      2.019963,
      1.132620,
      1,
      1,
      1.615102,
      0.583169,
      1.216116,
      1.766532,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      '30444',
      '',
      '',
      0.107783,
      '',
      NULL,
      '',
      3.363207,
      '24334',
      '',
      NULL,
      1,
      0.258094,
      3.721619,
      1,
      2,
      0,
      NULL,
      2,
      0.378043);
commit;
end;
/


