set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9038203';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-2-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '331',
      '43101110',
      39,
      NULL,
      NULL,
      98.362895,
      NULL,
      2.703229,
      2,
      '413210',
      NULL,
      ' 0-15-1986',
      55,
      NULL,
      1.488239,
      NULL,
      0.416203,
      NULL,
      0.637981,
      NULL,
      1,
      NULL,
      0.047509,
      1.143616,
      1,
      0.546522,
      NULL,
      0.697229,
      5.017227,
      0.792789,
      1.593954,
      1.473296,
      2,
      NULL,
      0,
      1.278765,
      0,
      NULL,
      6,
      NULL,
      0.832700,
      NULL,
      1.548416,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.537996,
      1,
      1.215851,
      1.101195,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.581093,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.022394,
      4,
      1.667953,
      0.371881,
      0.336480,
      5,
      2.748182,
      0.739943,
      0.437377,
      5.591682,
      NULL,
      0,
      NULL,
      3.367747,
      0.713591,
      0.239930,
      NULL,
      1,
      1.984028,
      NULL,
      0,
      1.933113,
      2.789362,
      1,
      0,
      2,
      1.161659,
      1.768409,
      3,
      1.809616,
      0,
      5,
      1,
      1.479259,
      0.426782,
      2.545675,
      NULL,
      NULL,
      0.519509,
      7.398013,
      4,
      8.074071,
      1.285057,
      9.048297,
      9.678571,
      0,
      NULL,
      3.996769,
      2,
      0.498362,
      NULL,
      5,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      0.343746,
      1,
      1.436112,
      0.423765,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.475973,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      1.396718,
      1,
      0.695240,
      7.849218,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.502436,
      0,
      6,
      4.815951,
      0.777430,
      1,
      3.954140,
      1,
      NULL,
      NULL,
      1.459232,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.979986,
      3.403455,
      0,
      0.550357,
      NULL,
      3,
      0,
      NULL,
      0.016757,
      3.556517,
      0.748821,
      0,
      0.944951,
      0,
      1,
      0.139391,
      1,
      0.193985,
      0,
      0.257143,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.937061,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      NULL,
      '',
      '',
      0,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      2,
      NULL,
      3,
      2,
      2,
      3,
      2,
      1,
      2.059882);
commit;
end;
/


